package org.gcube.vremanagement.contextmanager.handlers;

import java.util.List;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.vremanagement.contextmanager.ContextAppManager;
import org.gcube.vremanagement.contextmanager.model.operators.context.CustomContextOperator;
import org.gcube.vremanagement.contextmanager.model.operators.context.MandatoryContextOperator;


@Singleton
public class ContextHandler {
	
	@Inject
	@Any
	Instance<MandatoryContextOperator> mandatoryContextOperators;
	
	@Inject
	@Any
	Instance<CustomContextOperator> customContextOperators;
	
	public void createContext(String contextName, List<String> resourcesId, ContextAppManager appContext) {
		mandatoryContextOperators.forEach(co -> co.onCreateContext(SecurityTokenProvider.instance.get(), contextName, null));
	}
	
	public void removeContext(String contextName, ContextAppManager appContext) {
		mandatoryContextOperators.forEach(co -> co.onDisposeContext(SecurityTokenProvider.instance.get(), contextName, null));
	}
}
