package org.gcube.vremanagement.contextmanager.handlers.impl;

import java.util.Arrays;
import java.util.List;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resource.Type;
import org.gcube.vremanagement.contextmanager.handlers.ResourceHandler;
import org.gcube.vremanagement.contextmanager.model.collectors.BackendConnector;

public class StaticResourceHandler implements ResourceHandler {

	@Inject
	@Any
	Instance<BackendConnector> collectors;
	
	@Override
	public List<Type> getManagedResources() {
		return Arrays.asList(Type.GENERIC, Type.ENDPOINT);
	}

	@Override
	public void addResource(String contextName, Resource resource) {
		collectors.forEach(c-> c.addResourceToContext(contextName, resource));
		//ADD resource operator execution onAdd
	}

	@Override
	public void removeResource(String contextName, Resource resource) {
		collectors.forEach(c-> c.removeResourceFromContext(contextName, resource));
		//ADD resource operator execution onREmove
	}

	@Override
	public void createResourceNotified(String contextName, Resource resource) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void removeResourceNotified(String contextName, Resource resource) {
		// TODO Auto-generated method stub
		
	}
	
	
}
