package org.gcube.vremanagement.contextmanager.model.report;

import java.util.LinkedList;
import java.util.List;

public class ReportGroup implements ReportOperation{

	private String name;
	private String description;
	
	protected ReportGroup() {}
	
	private List<ReportEntry> entries = new LinkedList<>();
	
	public ReportGroup(String name, String description) {
		this.name = name;
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}
	
	public void addEntry(ReportEntry entry) {
		entries.add(entry);
	}
}
