/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.helloworld;

import java.util.Map;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.helloworld.HelloWorldPluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloWorldPlugin
extends Plugin<HelloWorldPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(HelloWorldPlugin.class);
    public static final String SLEEP_TIME = "sleepTime";

    public HelloWorldPlugin(HelloWorldPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.debug("contructor");
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        logger.debug("My UUID is {}", (Object)this.uuid.toString());
        logger.debug("My iteration number is {}", (Object)this.iterationNumber);
        logger.debug("Launching HelloWorld");
        if (inputs == null) {
            throw new InputsNullException();
        }
        if (inputs.isEmpty() || !inputs.containsKey(SLEEP_TIME)) {
            logger.debug("HelloWorld inputs {} are not valid", inputs);
            throw new InvalidInputsException();
        }
        this.setPercentageEvolution(20);
        logger.debug("{} - Inputs : {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), inputs);
        this.setPercentageEvolution(30);
        Object sleepTimeObject = inputs.get(SLEEP_TIME);
        Long sleepTime = sleepTimeObject instanceof Integer ? new Long(((Integer)sleepTimeObject).intValue()) : (sleepTimeObject instanceof Long ? (Long)sleepTimeObject : new Long(sleepTimeObject.toString()));
        Thread.sleep(sleepTime);
        this.setPercentageEvolution(90);
        logger.debug("HelloWorld finished");
    }

    protected void onStop() throws Exception {
        logger.debug("onStop()");
        Thread.currentThread().interrupt();
    }
}

