/**
 * 
 */
package org.gcube.vremanagement.executor.plugin;

import java.util.Map;


/**
 * @author Luca Frosini (ISTI - CNR)
 *
 */
public abstract class PluginStateNotification {

	/** Input configuration parameters for this notification handler */
	protected final Map<String, String> inputs;
	
	/**
	 * Constructor for PluginStateNotification.
	 * @param inputs configuration parameters for this notification handler
	 */
	public PluginStateNotification(Map<String, String> inputs){
		this.inputs = inputs;
	}
	
	/**
	 * Persist the new state of plugin
	 * @param pluginStateEvolution the PluginStateEvolution record to persist
	 * @param exception any exception that occurred during plugin execution (can be null)
	 * @throws Exception if fails
	 */
	public abstract void pluginStateEvolution(PluginStateEvolution pluginStateEvolution, Exception exception) 
			throws Exception;
}
