/**
 * 
 */
package org.gcube.vremanagement.executor.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.UUID;

import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class JDBCPersistence extends Persistence<JDBCPersistenceConnector> {

	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(JDBCPersistence.class);
	
	private final Connection connection;
	
	public JDBCPersistence(JDBCPersistenceConnector jdbcPersistenceConnector,
			String name, UUID uuid){
		super(jdbcPersistenceConnector, name, uuid);
		this.connection = jdbcPersistenceConnector.getConnection();
	}
	
	/**{@inheritDoc}*/
	@Override
	public void addEvolution(long timestamp, PluginState pluginState)
			throws Exception {

		connection.setAutoCommit(false); // transaction block start

		String insertPluginEvolution = String.format(
				"INSERT INTO `%s` (`%s`,`%s`,`%s`,`%s`) VALUES (?,?,?,?)",
				JDBCPersistenceConnector.PLUGIN_INSTANCE_EVOLUTION_TABLE, 
				JDBCPersistenceConnector.PLUGIN_INSTANCE_EVOLUTION_TABLE_UUID_FIELD,
				JDBCPersistenceConnector.PLUGIN_INSTANCE_EVOLUTION_TABLE_PLUGIN_NAME_FIELD, 
				JDBCPersistenceConnector.PLUGIN_INSTANCE_EVOLUTION_TABLE_TIMESTAMP_FIELD,
				JDBCPersistenceConnector.PLUGIN_INSTANCE_EVOLUTION_TABLE_STATE_FIELD);
		logger.info(String.format("Base Query : %s. Parameters : %s,%s%s,%s", 
				insertPluginEvolution, uuid.toString(), name, timestamp, 
				pluginState.name()));

		PreparedStatement psInsertPluginEvolution = connection
				.prepareStatement(insertPluginEvolution);
		
		psInsertPluginEvolution.setString(1, uuid.toString());
		psInsertPluginEvolution.setString(2, name);
		psInsertPluginEvolution.setLong(3, timestamp);
		psInsertPluginEvolution.setInt(4, pluginState.ordinal());
		
		psInsertPluginEvolution.executeUpdate();
		connection.commit(); //transaction block end
	}
	
}
