/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.vremanagement.executor.persistence.JDBCPersistenceConnector;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.pluginmanager.PluginThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlRootElement(name="plugin-registration-handler")
public class SmartExecutorInitalizator
extends ApplicationLifecycleHandler {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorInitalizator.class);
    private static ExecutorService pool;
    private static Map<UUID, PluginThread<Plugin<? extends PluginDeclaration>>> pluginInstances;
    private static ServiceEndpoint serviceEndpoint;
    private static JDBCPersistenceConnector jdbcPersistenceConnector;
    private static ApplicationContext ctx;

    public static ExecutorService getPool() {
        return pool;
    }

    public static Map<UUID, PluginThread<Plugin<? extends PluginDeclaration>>> getPluginInstances() {
        return pluginInstances;
    }

    public static JDBCPersistenceConnector getJdbcPersistenceConnector() {
        return jdbcPersistenceConnector;
    }

    public static ApplicationContext getCtx() {
        return ctx;
    }

    private static void publishScopedResource(Resource resource, List<String> scopes) throws RegistryNotFoundException, Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)resource, (Writer)stringWriter);
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        try {
            logger.debug("Trying to publish to {}:\n{}", scopes, (Object)stringWriter);
            scopedPublisher.create(resource, scopes);
        }
        catch (RegistryNotFoundException e) {
            logger.error("The resource was not published", (Throwable)e);
            throw e;
        }
    }

    private static void unPublishScopedResource(Resource resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        logger.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove(resource);
        logger.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    private static short[] getVersionSlice(String version, int wantedLenght) {
        logger.trace("Trying to parse {}", (Object)version);
        short[] versionSlices = new short[wantedLenght];
        for (int j = 0; j < wantedLenght; ++j) {
            versionSlices[j] = (short)(j == 0 ? 1 : 0);
        }
        try {
            String[] stringSlices = version.split("[.-]");
            for (int i = 0; i < stringSlices.length; ++i) {
                logger.trace("Parsing version slice n. {} wich is '{}'", (Object)i, (Object)stringSlices[i]);
                if (i < wantedLenght) {
                    try {
                        short n;
                        versionSlices[i] = n = Short.parseShort(stringSlices[i]);
                        logger.trace("Version slice n. {} wich is '{}' parsed as short {}", new Object[]{i, stringSlices[i], n});
                    }
                    catch (NumberFormatException nfe) {
                        logger.trace("Version slice n. {} wich is '{}' failed to parse. The default value {} will be used", new Object[]{i, stringSlices[i], versionSlices[i]});
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.trace("Error parsing the supplied version the default will be used", (Object)versionSlices);
        }
        logger.trace("Version {} parsed as {}", (Object)version, (Object)versionSlices);
        return versionSlices;
    }

    private static String getRunningOn(ContainerConfiguration containerConfiguration) {
        return String.format("%s:%s", containerConfiguration.hostname(), containerConfiguration.port());
    }

    protected static ServiceEndpoint createServiceEndpoint() {
        logger.debug("Getting Available Plugins and their own supported capabilities");
        PluginManager pluginManager = PluginManager.getInstance();
        logger.debug("Creating ServiceEndpoint to publish on IS available plugins and their own supported capabilities");
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        ServiceEndpoint.Profile profile = serviceEndpoint.newProfile();
        profile.category(ctx.configuration().serviceClass());
        profile.name(ctx.configuration().name());
        String version = ctx.configuration().version();
        profile.version(version);
        profile.description(ctx.configuration().description());
        String runningOn = SmartExecutorInitalizator.getRunningOn((ContainerConfiguration)ctx.container().configuration());
        Platform platform = profile.newPlatform();
        platform.name(runningOn);
        short[] versionSlices = SmartExecutorInitalizator.getVersionSlice((String)version, (int)4);
        platform.version(versionSlices[0]);
        platform.minorVersion(versionSlices[1]);
        platform.buildVersion(versionSlices[2]);
        platform.revisionVersion(versionSlices[3]);
        ServiceEndpoint.Runtime runtime = profile.newRuntime();
        runtime.hostedOn(runningOn);
        runtime.status(ctx.configuration().mode().toString());
        Group accessPoints = profile.accessPoints();
        Map availablePlugins = pluginManager.getAvailablePlugins();
        for (String pluginName : availablePlugins.keySet()) {
            ServiceEndpoint.AccessPoint accessPointElement = new ServiceEndpoint.AccessPoint();
            accessPointElement.name(pluginName);
            PluginDeclaration pluginDeclaration = (PluginDeclaration)availablePlugins.get(pluginName);
            accessPointElement.description(pluginDeclaration.getDescription());
            Group properties = accessPointElement.properties();
            ServiceEndpoint.Property propertyVersionElement = new ServiceEndpoint.Property();
            propertyVersionElement.nameAndValue("Version", pluginDeclaration.getVersion());
            properties.add((Object)propertyVersionElement);
            Map pluginCapablities = pluginDeclaration.getSupportedCapabilities();
            for (String capabilityName : pluginCapablities.keySet()) {
                ServiceEndpoint.Property propertyElement = new ServiceEndpoint.Property();
                propertyElement.nameAndValue(capabilityName, (String)pluginCapablities.get(capabilityName));
                properties.add((Object)propertyElement);
            }
            accessPoints.add((Object)accessPointElement);
        }
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)serviceEndpoint, (Writer)stringWriter);
        logger.debug("The created ServiceEndpoint profile is\n{}", (Object)stringWriter.toString());
        return serviceEndpoint;
    }

    public static List<String> getScopes(ApplicationContext applicationContext) {
        ScopeGroup scopeGroup = ((GCoreEndpoint)applicationContext.profile(GCoreEndpoint.class)).scopes();
        Collection scopes = scopeGroup.asCollection();
        return new ArrayList<String>(scopes);
    }

    public void onStart(ApplicationLifecycleEvent.Start applicationLifecycleEventStart) {
        logger.debug("\n-------------------------------------------------------\nSmart Executor is Starting\n-------------------------------------------------------");
        ctx = (ApplicationContext)applicationLifecycleEventStart.context();
        pool = Executors.newCachedThreadPool();
        serviceEndpoint = SmartExecutorInitalizator.createServiceEndpoint();
        pluginInstances = new HashMap();
        List scopes = SmartExecutorInitalizator.getScopes((ApplicationContext)ctx);
        for (String scope : scopes) {
            try {
                ScopeProvider.instance.set(scope);
                XQuery query = ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format("$resource/Profile/Category/text() eq '%s'", ctx.configuration().serviceClass())).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", ctx.configuration().name())).addCondition(String.format("$resource/Profile/RunTime/HostedOn/text() eq '%s'", SmartExecutorInitalizator.getRunningOn((ContainerConfiguration)ctx.container().configuration()))).setResult("$resource");
                DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
                List serviceEndpoints = client.submit((Query)query);
                for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
                    try {
                        logger.debug("Trying to unpublish the old ServiceEndpoint with ID {} from scope {}", (Object)serviceEndpoint.id(), (Object)scope);
                        SmartExecutorInitalizator.unPublishScopedResource((Resource)serviceEndpoint);
                    }
                    catch (Exception e) {
                        logger.debug("Exception tryng to unpublish the old ServiceEndpoint with ID {} from scope {}", new Object[]{serviceEndpoint.id(), scope, e});
                    }
                }
            }
            catch (Exception e) {
                logger.debug("An Exception occur while checking and/or unpublishing old ServiceEndpoint", (Throwable)e);
            }
        }
        try {
            SmartExecutorInitalizator.publishScopedResource((Resource)serviceEndpoint, (List)scopes);
        }
        catch (RegistryNotFoundException e) {
            logger.error("Unable to Create ServiceEndpoint. the Service will be aborted", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.error("Unable to Create ServiceEndpoint. the Service will be aborted", (Throwable)e);
            return;
        }
        try {
            jdbcPersistenceConnector = new JDBCPersistenceConnector(ctx.persistence().location());
        }
        catch (Exception e) {
            logger.error("Unable to initialize PersistenceConnector. The Service will be aborted", (Throwable)e);
            return;
        }
        logger.debug("\n-------------------------------------------------------\nSmart Executor Started Successfully\n-------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop(ApplicationLifecycleEvent.Stop applicationLifecycleEventStop) {
        logger.debug("\n-------------------------------------------------------\nSmart Executor is Stopping\n-------------------------------------------------------");
        for (UUID uuid : pluginInstances.keySet()) {
            try {
                PluginThread pluginThread = (PluginThread)pluginInstances.get(uuid);
                Plugin pluginInstace = pluginThread.getPlugin();
                try {
                    logger.debug("Requesting Stop to plugin instance identified by the UUID %s of Plugin named {}", (Object)uuid, (Object)pluginInstace.getPluginDeclaration().getName());
                    pluginInstace.stop();
                    logger.debug("Plugin instance identified by the UUID {} of Plugin named {} stopped coorectly itself", (Object)uuid, (Object)pluginInstace.getPluginDeclaration().getName());
                }
                catch (Exception e) {
                    logger.debug("Running plugin instance identified by the UUID {} of Plugin named {} failed to request of being stopped", (Object)uuid, (Object)pluginInstace.getPluginDeclaration().getName());
                }
                finally {
                    pluginInstace.setState(PluginState.SUSPENDED);
                    pluginInstances.remove(uuid);
                }
            }
            catch (Exception e) {
                logger.error("Error stopping plugin instace with UUID {}", (Object)uuid, (Object)e);
            }
        }
        pool.shutdown();
        try {
            List scopes = SmartExecutorInitalizator.getScopes((ApplicationContext)ctx);
            for (String scope : scopes) {
                ScopeProvider.instance.set(scope);
                SmartExecutorInitalizator.unPublishScopedResource((Resource)serviceEndpoint);
            }
        }
        catch (RegistryNotFoundException e) {
            logger.error("Unable to unpublish Service Endpoint.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unable to unpublish Service Endpoint.", (Throwable)e);
        }
        try {
            jdbcPersistenceConnector.close();
        }
        catch (Exception e) {
            logger.error("Unable to close Persistence", (Throwable)e);
        }
        logger.debug("\n-------------------------------------------------------\nSmart Executor Stopped Successfully\n-------------------------------------------------------");
    }
}

