/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.configuration.jsonbased;

import java.text.ParseException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.exception.ScopeNotMatchException;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JSONScheduling
extends Scheduling {
    private static Logger logger = LoggerFactory.getLogger(JSONScheduling.class);
    public static final String CRON_EXPRESSION = "cronExpression";
    public static final String DELAY = "delay";
    public static final String SCHEDULING_TIMES = "schedulingTimes";
    public static final String FIRST_START_TIME = "firstStartTime";
    public static final String END_TIME = "endTime";
    public static final String PREVIUOS_EXECUTION_MUST_BE_COMPLETED = "previuosExecutionsMustBeCompleted";
    public static final String SCOPE = "scope";
    protected final String scope;

    public JSONScheduling(Scheduling scheduling) throws ParseException {
        this.init(new CronExpression(scheduling.getCronExpression()), scheduling.getDelay(), scheduling.getSchedulingTimes(), scheduling.getFirtStartTime(), scheduling.getEndTime(), scheduling.mustPreviousExecutionsCompleted());
        this.scope = ScopeProvider.instance.get();
    }

    public JSONScheduling(JSONObject jsonObject) throws JSONException, ParseException, ScopeNotMatchException {
        String jsonScope;
        CronExpression cronExpression = null;
        if (jsonObject.has(CRON_EXPRESSION)) {
            String cronExpressionString = jsonObject.getString(CRON_EXPRESSION);
            cronExpression = new CronExpression(cronExpressionString);
        }
        Integer delay = null;
        if (jsonObject.has(DELAY)) {
            delay = jsonObject.getInt(DELAY);
        }
        Integer schedulingTimes = 0;
        if (jsonObject.has(SCHEDULING_TIMES)) {
            schedulingTimes = jsonObject.getInt(SCHEDULING_TIMES);
        }
        Long firstStartTime = null;
        if (jsonObject.has(FIRST_START_TIME)) {
            firstStartTime = jsonObject.getLong(FIRST_START_TIME);
        }
        Long endTime = null;
        if (jsonObject.has(FIRST_START_TIME)) {
            endTime = jsonObject.getLong(END_TIME);
        }
        Boolean previuosExecutionsMustBeCompleted = false;
        if (jsonObject.has(PREVIUOS_EXECUTION_MUST_BE_COMPLETED)) {
            previuosExecutionsMustBeCompleted = jsonObject.getBoolean(PREVIUOS_EXECUTION_MUST_BE_COMPLETED);
        }
        this.init(cronExpression, delay, schedulingTimes.intValue(), firstStartTime, endTime, previuosExecutionsMustBeCompleted.booleanValue());
        this.scope = ScopeProvider.instance.get();
        if (jsonObject.has(SCOPE) && (jsonScope = jsonObject.getString(SCOPE)).compareTo(this.scope) != 0) {
            String message = String.format("The current scope %s differs from the one provide in %s provided as argument %s.", this.scope, JSONObject.class.getSimpleName(), jsonScope);
            logger.error(message);
            throw new ScopeNotMatchException(message);
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        if (this.cronExpression != null) {
            obj.put(CRON_EXPRESSION, (Object)this.cronExpression);
        }
        if (this.delay != null) {
            obj.put(DELAY, this.delay.intValue());
        }
        obj.put(SCHEDULING_TIMES, this.schedulingTimes);
        if (this.firstStartTime != null) {
            obj.put(FIRST_START_TIME, (Object)this.firstStartTime);
        }
        if (this.endTime != null) {
            obj.put(END_TIME, (Object)this.endTime);
        }
        obj.put(PREVIUOS_EXECUTION_MUST_BE_COMPLETED, this.previuosExecutionsMustBeCompleted);
        obj.put(SCOPE, (Object)this.scope);
        return obj;
    }
}

