/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmartExecutorInitializator
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorInitializator.class);
    public static final long JOIN_TIMEOUT = 1000L;

    public static String getScopeFromToken() {
        AuthorizationEntry authorizationEntry;
        String token = SecurityTokenProvider.instance.get();
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    private static void publishResource(Resource resource) throws Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)resource, (Writer)stringWriter);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        try {
            logger.debug("Trying to publish to {}:\n{}", (Object)SmartExecutorInitializator.getScopeFromToken(), (Object)stringWriter);
            registryPublisher.create(resource);
        }
        catch (Exception e) {
            logger.error("The resource was not published", (Throwable)e);
            throw e;
        }
    }

    private static void unPublishResource(Resource resource) throws Exception {
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        String id = resource.id();
        logger.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, SmartExecutorInitializator.getScopeFromToken()});
        registryPublisher.remove(resource);
        logger.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    private static short[] getVersionSlice(String version, int wantedLenght) {
        logger.trace("Trying to parse {}", (Object)version);
        short[] versionSlices = new short[wantedLenght];
        for (int j = 0; j < wantedLenght; ++j) {
            versionSlices[j] = (short)(j == 0 ? 1 : 0);
        }
        try {
            String[] stringSlices = version.split("[.-]");
            for (int i = 0; i < stringSlices.length; ++i) {
                logger.trace("Parsing version slice n. {} wich is '{}'", (Object)i, (Object)stringSlices[i]);
                if (i < wantedLenght) {
                    try {
                        short n;
                        versionSlices[i] = n = Short.parseShort(stringSlices[i]);
                        logger.trace("Version slice n. {} wich is '{}' parsed as short {}", new Object[]{i, stringSlices[i], n});
                    }
                    catch (NumberFormatException nfe) {
                        logger.trace("Version slice n. {} wich is '{}' failed to parse. The default value {} will be used", new Object[]{i, stringSlices[i], versionSlices[i]});
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.trace("Error parsing the supplied version the default will be used", (Object)versionSlices);
        }
        logger.trace("Version {} parsed as {}", (Object)version, (Object)versionSlices);
        return versionSlices;
    }

    private static String getRunningOn(ContainerConfiguration containerConfiguration) {
        return String.format("%s:%s", containerConfiguration.hostname(), containerConfiguration.port());
    }

    protected static ServiceEndpoint createServiceEndpoint() {
        logger.debug("Getting Available Plugins and their own supported capabilities");
        PluginManager pluginManager = PluginManager.getInstance();
        logger.debug("Creating ServiceEndpoint to publish on IS available plugins and their own supported capabilities");
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        ServiceEndpoint.Profile profile = serviceEndpoint.newProfile();
        profile.category(ContextProvider.get().configuration().serviceClass());
        profile.name(ContextProvider.get().configuration().name());
        String version = ContextProvider.get().configuration().version();
        profile.version(version);
        profile.description(ContextProvider.get().configuration().description());
        String runningOn = SmartExecutorInitializator.getRunningOn((ContainerConfiguration)ContextProvider.get().container().configuration());
        Platform platform = profile.newPlatform();
        platform.name(runningOn);
        short[] versionSlices = SmartExecutorInitializator.getVersionSlice((String)version, (int)4);
        platform.version(versionSlices[0]);
        platform.minorVersion(versionSlices[1]);
        platform.buildVersion(versionSlices[2]);
        platform.revisionVersion(versionSlices[3]);
        ServiceEndpoint.Runtime runtime = profile.newRuntime();
        runtime.hostedOn(runningOn);
        runtime.status(ContextProvider.get().configuration().mode().toString());
        Group accessPoints = profile.accessPoints();
        Map availablePlugins = pluginManager.getAvailablePlugins();
        for (String pluginName : availablePlugins.keySet()) {
            ServiceEndpoint.AccessPoint accessPointElement = new ServiceEndpoint.AccessPoint();
            accessPointElement.name(pluginName);
            PluginDeclaration pluginDeclaration = (PluginDeclaration)availablePlugins.get(pluginName);
            accessPointElement.description(pluginDeclaration.getDescription());
            Group properties = accessPointElement.properties();
            ServiceEndpoint.Property propertyVersionElement = new ServiceEndpoint.Property();
            propertyVersionElement.nameAndValue("Version", pluginDeclaration.getVersion());
            properties.add((Object)propertyVersionElement);
            Map pluginCapabilities = pluginDeclaration.getSupportedCapabilities();
            for (String capabilityName : pluginCapabilities.keySet()) {
                ServiceEndpoint.Property propertyElement = new ServiceEndpoint.Property();
                propertyElement.nameAndValue(capabilityName, (String)pluginCapabilities.get(capabilityName));
                properties.add((Object)propertyElement);
            }
            accessPoints.add((Object)accessPointElement);
        }
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)serviceEndpoint, (Writer)stringWriter);
        logger.debug("The created ServiceEndpoint profile is\n{}", (Object)stringWriter.toString());
        return serviceEndpoint;
    }

    private void cleanServiceEndpoints() {
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format("$resource/Profile/Category/text() eq '%s'", ContextProvider.get().configuration().serviceClass())).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", ContextProvider.get().configuration().name())).addCondition(String.format("$resource/Profile/RunTime/HostedOn/text() eq '%s'", SmartExecutorInitializator.getRunningOn((ContainerConfiguration)ContextProvider.get().container().configuration()))).setResult("$resource");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List serviceEndpoints = client.submit((Query)query);
            for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
                try {
                    logger.debug("Trying to unpublish the old ServiceEndpoint with ID {} from scope {}", (Object)serviceEndpoint.id(), (Object)SmartExecutorInitializator.getScopeFromToken());
                    SmartExecutorInitializator.unPublishResource((Resource)serviceEndpoint);
                }
                catch (Exception e) {
                    logger.debug("Exception tryng to unpublish the old ServiceEndpoint with ID {} from scope {}", new Object[]{serviceEndpoint.id(), SmartExecutorInitializator.getScopeFromToken(), e});
                }
            }
        }
        catch (Exception e) {
            logger.debug("An Exception occur while checking and/or unpublishing old ServiceEndpoint", (Throwable)e);
        }
    }

    public void onInit() {
        String scope = SmartExecutorInitializator.getScopeFromToken();
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Starting on scope {}\n-------------------------------------------------------", (Object)scope);
        ServiceEndpoint serviceEndpoint = SmartExecutorInitializator.createServiceEndpoint();
        this.cleanServiceEndpoints();
        try {
            SmartExecutorPersistenceFactory.getPersistenceConnector((String)scope);
        }
        catch (Exception e) {
            logger.error("Unable to instantiate {} for scope {}", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), scope, e});
            throw new RuntimeException(e);
        }
        try {
            SmartExecutorInitializator.publishResource((Resource)serviceEndpoint);
        }
        catch (RegistryNotFoundException e) {
            logger.error("Unable to Create ServiceEndpoint. the Service will be aborted", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.error("Unable to Create ServiceEndpoint. the Service will be aborted", (Throwable)e);
            return;
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Started Successfully on scope {}\n-------------------------------------------------------", (Object)scope);
    }

    public void onShutdown() {
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Stopping on scope {}\n-------------------------------------------------------", (Object)SmartExecutorInitializator.getScopeFromToken());
        SmartExecutorScheduler.getInstance().stopAll();
        this.cleanServiceEndpoints();
        try {
            SmartExecutorPersistenceFactory.getPersistenceConnector().close();
        }
        catch (Exception e) {
            logger.error("Unable to correctly close {} for scope {}", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), SmartExecutorInitializator.getScopeFromToken(), e});
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Stopped Successfully on scope {}\n-------------------------------------------------------", (Object)SmartExecutorInitializator.getScopeFromToken());
    }
}

