/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.configuration.jsonbased;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.configuration.jsonbased.JSONScheduling;
import org.gcube.vremanagement.executor.exception.ScopeNotMatchException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONLaunchParameter
extends LaunchParameter {
    private static Logger logger = LoggerFactory.getLogger(JSONLaunchParameter.class);
    public static final String PLUGIN_NAME = "pluginName";
    public static final String PLUGIN_CAPABILITIES = "pluginCapabilites";
    public static final String INPUTS = "inputs";
    public static final String SCHEDULING = "scheduling";
    public static final String USED_BY = "usedBy";
    public static final String SCOPE = "SCOPE";
    protected String usedBy;
    protected String scope;

    private JSONLaunchParameter() {
    }

    public JSONLaunchParameter(String pluginName, Map<String, Object> inputs) {
        super(pluginName, inputs);
    }

    public JSONLaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs) {
        super(pluginName, pluginCapabilities, inputs);
        this.scope = SmartExecutorInitializator.getScopeFromToken();
    }

    public JSONLaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling) throws ParseException {
        super(pluginName, inputs, scheduling);
        this.scope = SmartExecutorInitializator.getScopeFromToken();
    }

    public JSONLaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) throws ParseException {
        super(pluginName, pluginCapabilities, inputs, scheduling);
        this.scope = SmartExecutorInitializator.getScopeFromToken();
    }

    public JSONLaunchParameter(LaunchParameter parameter) throws ParseException {
        super(parameter.getPluginName(), parameter.getPluginCapabilities(), parameter.getInputs(), parameter.getScheduling());
        this.scheduling = new JSONScheduling(parameter.getScheduling());
        this.scope = SmartExecutorInitializator.getScopeFromToken();
    }

    public JSONLaunchParameter(JSONObject jsonObject) throws JSONException, ParseException, ScopeNotMatchException {
        String jsonScope;
        String key;
        int j;
        JSONArray names;
        this.pluginName = jsonObject.getString(PLUGIN_NAME);
        this.pluginCapabilities = null;
        if (jsonObject.has(PLUGIN_CAPABILITIES)) {
            this.pluginCapabilities = new HashMap();
            JSONObject capabilities = jsonObject.getJSONObject(PLUGIN_CAPABILITIES);
            names = capabilities.names();
            for (j = 0; j < names.length(); ++j) {
                key = names.getString(j);
                this.pluginCapabilities.put(key, capabilities.getString(key));
            }
        }
        this.inputs = new HashMap();
        JSONObject inputsJsonObject = jsonObject.getJSONObject(INPUTS);
        names = inputsJsonObject.names();
        for (j = 0; j < names.length(); ++j) {
            key = names.getString(j);
            this.inputs.put(key, inputsJsonObject.get(key));
        }
        if (jsonObject.has(SCHEDULING)) {
            JSONObject schedulingJsonObject = jsonObject.getJSONObject(SCHEDULING);
            this.scheduling = new JSONScheduling(schedulingJsonObject);
        }
        if (jsonObject.has(USED_BY)) {
            this.usedBy = jsonObject.getString(USED_BY);
        }
        this.scope = SmartExecutorInitializator.getScopeFromToken();
        if (jsonObject.has(SCOPE) && (jsonScope = jsonObject.getString(SCOPE)).compareTo(this.scope) != 0) {
            String message = String.format("The current scope %s differs from the one provide in %s provided as argument %s.", this.scope, JSONObject.class.getSimpleName(), jsonScope);
            logger.error(message);
            throw new ScopeNotMatchException(message);
        }
    }

    public JSONScheduling getScheduling() {
        return (JSONScheduling)this.scheduling;
    }

    public void setScheduling(JSONScheduling scheduling) {
        this.scheduling = scheduling;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(PLUGIN_NAME, (Object)this.pluginName);
        if (this.pluginCapabilities != null && !this.pluginCapabilities.isEmpty()) {
            JSONObject capabilities = new JSONObject();
            for (String id : this.pluginCapabilities.keySet()) {
                capabilities.put(id, this.pluginCapabilities.get(id));
            }
            obj.put(PLUGIN_CAPABILITIES, (Object)capabilities);
        }
        JSONObject inputJsonObject = new JSONObject();
        for (String id : this.inputs.keySet()) {
            inputJsonObject.put(id, this.inputs.get(id));
        }
        obj.put(INPUTS, (Object)inputJsonObject);
        if (this.scheduling != null) {
            obj.put(SCHEDULING, (Object)this.getScheduling().toJSON());
        }
        if (this.usedBy != null) {
            obj.put(USED_BY, (Object)this.usedBy);
        }
        if (this.scope != null) {
            obj.put(SCOPE, (Object)this.scope);
        }
        return obj;
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (JSONException e) {
            return String.format("%s : %s", this.getClass().getSimpleName(), super.toString());
        }
    }

    public String getUsedBy() {
        return this.usedBy;
    }

    public void setUsedBy(String usedBy) {
        this.usedBy = usedBy;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

