package org.gcube.vremanagement.executor.ispublisher;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.AddConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.RemoveConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.client.Direction;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.resourcemanagement.model.impl.entities.facets.SimplePropertyFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.RunningPluginImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.ActivatesImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.EnablesImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimplePropertyFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.RunningPlugin;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.entities.resources.Software;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Enables;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestISPublisher extends ISPublisher {

	private static Logger logger = LoggerFactory.getLogger(RestISPublisher.class);
	
	protected final UUID eServiceUUID;
	protected ResourceRegistryClient resourceRegistryClient;
	protected ResourceRegistryPublisher resourceRegistryPublisher;
	
	
	
	public RestISPublisher(ApplicationContext applicationContext) {
		super(applicationContext);
		this.eServiceUUID = UUID.fromString(applicationContext.id());
		this.resourceRegistryClient = ResourceRegistryClientFactory.create();
		this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
	}

	@SuppressWarnings("unused")
	protected RunningPlugin publishRunningPluginWithRelations(Plugin plugin, UUID pluginUUID) throws Exception {
		
		RunningPlugin runningPlugin = new RunningPluginImpl();
		runningPlugin.setHeader(new HeaderImpl(pluginUUID));
		
		SoftwareFacet softwareFacet = new SoftwareFacetImpl();
		softwareFacet.setGroup(plugin.getGroup());
		softwareFacet.setName(plugin.getName());
		softwareFacet.setVersion(plugin.getVersion());
		softwareFacet.setDescription(plugin.getDescription());
		
		IsIdentifiedBy<Resource, Facet> isIdentifiedBy = new IsIdentifiedByImpl<Resource, Facet>(runningPlugin, softwareFacet);
		runningPlugin.addFacet(isIdentifiedBy);
		
		Map<String,String> pluginCapabilities = plugin.getSupportedCapabilities();
		if(pluginCapabilities!=null) {
			for(String capabilityName : pluginCapabilities.keySet()) {
				SimplePropertyFacet simplePropertyFacet = new SimplePropertyFacetImpl();
				simplePropertyFacet.setName(capabilityName);
				simplePropertyFacet.setValue(pluginCapabilities.get(capabilityName));
				runningPlugin.addFacet(simplePropertyFacet);
			}
		}
		
		EService smartExecutorEService = resourceRegistryClient.getInstance(EService.class, eServiceUUID);
		PropagationConstraint usesPropagationConstraint = new PropagationConstraintImpl();
		usesPropagationConstraint.setAddConstraint(AddConstraint.propagate);
		usesPropagationConstraint.setRemoveConstraint(RemoveConstraint.cascade);
		
		Activates<EService, RunningPlugin> activates = new ActivatesImpl<EService, RunningPlugin>(smartExecutorEService, runningPlugin, usesPropagationConstraint);
		try {
			resourceRegistryPublisher.createIsRelatedTo(activates);
		} catch (ResourceRegistryException e) {
			logger.error("Unable to publish %s instace %s for plugin %s. I'm going to stop the service.", Resource.NAME, RunningPlugin.NAME, plugin.getName());
			throw e;
		}
		
		org.gcube.resourcemanagement.model.reference.entities.resources.Plugin pluginResource = null;
		if(pluginResource!=null) { // The if allows not commenting the following code in the meanwhile the pluginResource retrieving is properly coded
			PropagationConstraint enablesPropagationConstraint = new PropagationConstraintImpl();
			enablesPropagationConstraint.setAddConstraint(AddConstraint.propagate);
			enablesPropagationConstraint.setRemoveConstraint(RemoveConstraint.keep);
			Enables<Service, Software> enables = new EnablesImpl<Service, Software>(runningPlugin, pluginResource, enablesPropagationConstraint);
			try {
				resourceRegistryPublisher.createIsRelatedTo(enables);
			} catch (ResourceRegistryException e) {
				logger.error("Unable to publish %s instace %s for plugin %s. I'm going to stop the service.", Resource.NAME, RunningPlugin.NAME, plugin.getName());
				throw e;
			}
		}
		
		return runningPlugin;
	}
	
	@Override
	public void publishPlugins(Map<String, Class<? extends Plugin>> availablePlugins) throws Exception {
		PluginManager pluginManager = PluginManager.getInstance();
		
		for(String pluginName : availablePlugins.keySet()) {
			
			Plugin plugin = pluginManager.getPlugin(pluginName);
			UUID pluginUUID = pluginManager.getPluginUUID(pluginName);
			
			RunningPlugin runningPlugin;
			
			try {
				runningPlugin  = resourceRegistryClient.getInstance(RunningPlugin.class, pluginUUID);
			} catch (NotFoundException e) {
				runningPlugin = publishRunningPluginWithRelations(plugin, pluginUUID);
			} catch (AvailableInAnotherContextException e) {
				runningPlugin = new RunningPluginImpl();
				runningPlugin.setHeader(new HeaderImpl(pluginUUID));
				resourceRegistryPublisher.addToCurrentContext(runningPlugin);
			} catch (ResourceRegistryException e) {
				throw e;
			}
			
		}
	}
	
	@Override
	public void unpublishPlugins(boolean force) throws Exception {
		if(force) {
			List<RunningPlugin> runningPlugins = resourceRegistryClient.getRelatedResourcesFromReferenceResource(RunningPlugin.class, Activates.class, EService.class, this.eServiceUUID, Direction.IN, true);
			for(RunningPlugin runningPlugin : runningPlugins) {
				resourceRegistryPublisher.delete(runningPlugin);
			}
		}else {
			logger.info("The Plugin will be removed when the Eservice will be removed thanks to propagation contraints. Nothing to do");
		}
		
	}
	
}
