/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.smartgears.ContextProvider;
import org.gcube.vremanagement.executor.client.SmartExecutorClientImpl;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.gcube.vremanagement.executor.plugin.RunOn;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTaskPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartExecutorPersistenceConnector
extends PluginStateNotification
implements ScheduledTaskPersistence {
    private static final Logger logger = LoggerFactory.getLogger(SmartExecutorPersistenceConnector.class);

    public SmartExecutorPersistenceConnector() {
        super(new HashMap());
    }

    public abstract void close() throws Exception;

    public abstract PluginStateEvolution getPluginInstanceState(UUID var1, Integer var2) throws PluginInstanceNotFoundException, ExecutorException;

    public boolean isOrphan(ScheduledTask scheduledTask, boolean sameHost) throws ExecutorException {
        try {
            UUID uuid = scheduledTask.getUUID();
            RunOn runOn = scheduledTask.getRunOn();
            if (runOn == null) {
                return true;
            }
            try {
                if (sameHost) {
                    HostingNode hostingNode = (HostingNode)ContextProvider.get().container().profile(HostingNode.class);
                    String hnAddress = hostingNode.profile().description().name();
                    if (runOn.getHostingNode().getAddress().compareTo(hnAddress) == 0) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to check if current hosting node is the same of the one in ScheduledTask", (Throwable)e);
            }
            String address = runOn.getEService().getAddress();
            String pluginName = scheduledTask.getLaunchParameter().getPluginName();
            try {
                SmartExecutorClientImpl smartExecutorClient = new SmartExecutorClientImpl();
                smartExecutorClient.setAddress(address);
                smartExecutorClient.setPluginName(pluginName);
                smartExecutorClient.getPluginStateEvolution(uuid);
                logger.trace("{} is not orphan.", (Object)ExtendedSEMapper.getInstance().marshal((Object)scheduledTask));
                return false;
            }
            catch (WebApplicationException | DiscoveryException e) {
                logger.trace("{} is considered orphan.", (Object)ExtendedSEMapper.getInstance().marshal((Object)scheduledTask), (Object)e);
                return true;
            }
            catch (Throwable e) {
                logger.trace("{} is NOT considered orphan.", (Object)ExtendedSEMapper.getInstance().marshal((Object)scheduledTask), (Object)e);
                return false;
            }
        }
        catch (Exception e) {
            try {
                String string = ExtendedSEMapper.getInstance().marshal((Object)scheduledTask);
                logger.error("Error while checking orphanity of " + string + ". Considering as not orphan.", (Throwable)e);
            }
            catch (Exception ex) {
                logger.error("", (Object)e, (Object)ex);
            }
            return false;
        }
    }
}

