/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.ispublisher;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.resourcemanagement.model.impl.entities.facets.AccessPointFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.EventFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SimplePropertyFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.StateFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.RunningPluginImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.ActivatesImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.EnablesImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.RunningPlugin;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.entities.resources.Software;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.vremanagement.executor.ResourceInitializer;
import org.gcube.vremanagement.executor.ispublisher.ISPublisher;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestISPublisher
extends ISPublisher {
    private static Logger logger = LoggerFactory.getLogger(RestISPublisher.class);
    protected final UUID eServiceUUID;
    protected ResourceRegistryClient resourceRegistryClient;
    protected ResourceRegistryPublisher resourceRegistryPublisher;

    public RestISPublisher(ApplicationContext applicationContext) {
        super(applicationContext);
        this.eServiceUUID = UUID.fromString(applicationContext.id());
        this.resourceRegistryClient = ResourceRegistryClientFactory.create();
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
    }

    protected URI getPluginEndpoint(String pluginName, AccessPointFacet smartExecutorAccessPointFacet) throws Exception {
        URI smartExecutorEndpoint = this.getSmartExecutorEndpoint(smartExecutorAccessPointFacet);
        String pluginPath = String.format("plugins/%s/executions", pluginName);
        URI pluginEndpoint = new URI(smartExecutorEndpoint + pluginPath);
        return pluginEndpoint;
    }

    protected AccessPointFacet getPluginAccessPointFacet(Plugin plugin, AccessPointFacet smartExecutorAccessPointFacet) throws Exception {
        AccessPointFacetImpl accessPointFacet = new AccessPointFacetImpl();
        URI pluginEndpoint = this.getPluginEndpoint(plugin.getName(), smartExecutorAccessPointFacet);
        accessPointFacet.setEndpoint(pluginEndpoint);
        accessPointFacet.setDescription("The " + plugin.getName() + " smart-executor plugin endpoint");
        if (smartExecutorAccessPointFacet != null) {
            accessPointFacet.setAuthorization(smartExecutorAccessPointFacet.getAuthorization());
        }
        accessPointFacet.setEntryName(plugin.getClass().getName());
        return accessPointFacet;
    }

    protected AccessPointFacet getSmartExecutorAccessPointFacet(EService smartExecutorEService) {
        AccessPointFacet smartExecutorAccessPointFacet = null;
        List smartExecutorAccessPointFacets = smartExecutorEService.getFacets(AccessPointFacet.class);
        for (AccessPointFacet accessPointFacet : smartExecutorAccessPointFacets) {
            if (accessPointFacet.getEntryName().compareTo(ResourceInitializer.class.getName()) != 0) continue;
            smartExecutorAccessPointFacet = accessPointFacet;
            break;
        }
        return smartExecutorAccessPointFacet;
    }

    protected URI getSmartExecutorEndpoint(AccessPointFacet smartExecutorAccessPointFacet) throws URISyntaxException {
        URI smartExecutorEndpoint = null;
        smartExecutorEndpoint = smartExecutorAccessPointFacet != null ? smartExecutorAccessPointFacet.getEndpoint() : new URI(this.getBaseAddress());
        return smartExecutorEndpoint;
    }

    private String getBaseAddress() {
        String baseAddress;
        ApplicationConfiguration configuration = this.applicationContext.configuration();
        ContainerConfiguration container = this.applicationContext.container().configuration();
        if (configuration.proxied()) {
            String protocol = configuration.proxyAddress().protocol();
            String port = configuration.proxyAddress().port() != null ? ":" + configuration.proxyAddress().port() : "";
            baseAddress = String.format("%s://%s%s%s", protocol, configuration.proxyAddress().hostname(), port, this.applicationContext.application().getContextPath());
        } else {
            String protocol = container.protocol();
            int port = container.port();
            baseAddress = String.format("%s://%s:%d%s", protocol, container.hostname(), port, this.applicationContext.application().getContextPath());
        }
        return baseAddress;
    }

    protected RunningPlugin publishRunningPluginWithRelations(Plugin plugin, UUID pluginUUID) throws Exception {
        RunningPluginImpl runningPlugin = new RunningPluginImpl();
        runningPlugin.setID(pluginUUID);
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setGroup(plugin.getGroup());
        softwareFacet.setName(plugin.getName());
        softwareFacet.setVersion(plugin.getVersion());
        softwareFacet.setDescription(plugin.getDescription());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)runningPlugin, (Facet)softwareFacet);
        runningPlugin.addFacet((ConsistsOf)isIdentifiedBy);
        Map pluginCapabilities = plugin.getSupportedCapabilities();
        if (pluginCapabilities != null) {
            for (String capabilityName : pluginCapabilities.keySet()) {
                SimplePropertyFacetImpl simplePropertyFacet = new SimplePropertyFacetImpl();
                simplePropertyFacet.setName(capabilityName);
                simplePropertyFacet.setValue((String)pluginCapabilities.get(capabilityName));
                runningPlugin.addFacet((Facet)simplePropertyFacet);
            }
        }
        EService smartExecutorEService = (EService)this.resourceRegistryClient.getInstance(EService.class, this.eServiceUUID);
        PropagationConstraintImpl usesPropagationConstraint = new PropagationConstraintImpl();
        usesPropagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
        usesPropagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        AccessPointFacet smartExecutorAccessPointFacet = this.getSmartExecutorAccessPointFacet(smartExecutorEService);
        URI smartExecutorEndpoint = this.getSmartExecutorEndpoint(smartExecutorAccessPointFacet);
        AccessPointFacet accessPointFacet = this.getPluginAccessPointFacet(plugin, smartExecutorAccessPointFacet);
        runningPlugin.addFacet((Facet)accessPointFacet);
        Date date = Calendar.getInstance().getTime();
        StateFacetImpl stateFacet = new StateFacetImpl();
        stateFacet.setValue(ApplicationState.active.remoteForm().toLowerCase());
        stateFacet.setAdditionalProperty("date", (Object)date);
        runningPlugin.addFacet((Facet)stateFacet);
        EventFacetImpl eventFacet = new EventFacetImpl();
        eventFacet.setDate(date);
        eventFacet.setEvent(stateFacet.getValue());
        runningPlugin.addFacet((Facet)eventFacet);
        ActivatesImpl activates = new ActivatesImpl((Service)smartExecutorEService, (Service)runningPlugin, (PropagationConstraint)usesPropagationConstraint);
        try {
            this.resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)activates);
        }
        catch (ResourceRegistryException e) {
            logger.error("Unable to publish %s instace %s for plugin %s. I'm going to stop the service.", new Object[]{"Resource", "RunningPlugin", plugin.getName()});
            throw e;
        }
        Software pluginResource = null;
        if (pluginResource != null) {
            PropagationConstraintImpl enablesPropagationConstraint = new PropagationConstraintImpl();
            enablesPropagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
            enablesPropagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.keep);
            EnablesImpl enables = new EnablesImpl((Service)runningPlugin, pluginResource, (PropagationConstraint)enablesPropagationConstraint);
            try {
                this.resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)enables);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to publish %s instace %s for plugin %s. I'm going to stop the service.", new Object[]{"Resource", "RunningPlugin", plugin.getName()});
                throw e;
            }
        }
        return runningPlugin;
    }

    @Override
    public void publishPlugins(Map<String, Class<? extends Plugin>> availablePlugins) throws Exception {
        PluginManager pluginManager = PluginManager.getInstance();
        for (String pluginName : availablePlugins.keySet()) {
            RunningPluginImpl runningPlugin;
            Plugin plugin = pluginManager.getPlugin(pluginName);
            UUID pluginUUID = pluginManager.getPluginUUID(pluginName);
            try {
                runningPlugin = (RunningPlugin)this.resourceRegistryClient.getInstance(RunningPlugin.class, pluginUUID);
            }
            catch (NotFoundException e) {
                runningPlugin = this.publishRunningPluginWithRelations(plugin, pluginUUID);
            }
            catch (AvailableInAnotherContextException e) {
                runningPlugin = new RunningPluginImpl();
                runningPlugin.setID(pluginUUID);
                this.resourceRegistryPublisher.addToCurrentContext((ERElement)runningPlugin, Boolean.valueOf(false));
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
        }
    }

    @Override
    public void unpublishPlugins(boolean force) throws Exception {
        if (force) {
            List runningPlugins = this.resourceRegistryClient.getRelatedResourcesFromReferenceResource(RunningPlugin.class, Activates.class, EService.class, this.eServiceUUID, Direction.IN, true);
            for (RunningPlugin runningPlugin : runningPlugins) {
                this.resourceRegistryPublisher.delete((ERElement)runningPlugin);
            }
        } else {
            logger.info("The Plugin will be removed when the Eservice will be removed thanks to propagation contraints. Nothing to do");
        }
    }
}

