/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.exception.UnableToInterruptTaskException;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTaskPersistence;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTaskPersistenceFactory;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorTask;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorTaskListener;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorScheduler {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorScheduler.class);
    protected Set<UUID> scheduledJobs;
    protected Scheduler scheduler;

    SmartExecutorScheduler(Scheduler scheduler) throws SchedulerException {
        this.scheduler = scheduler;
        this.scheduler.start();
        this.scheduledJobs = new HashSet<UUID>();
    }

    protected TriggerBuilder<? extends Trigger> createTriggerBuilder(UUID uuid, ScheduleBuilder<? extends Trigger> sb) {
        return TriggerBuilder.newTrigger().withIdentity(uuid.toString()).withSchedule(sb);
    }

    protected TriggerBuilder<? extends Trigger> getTriggerBuilderWithScheduling(UUID uuid, Scheduling scheduling) throws LaunchException {
        int times = scheduling.getSchedulingTimes();
        if (scheduling.getCronExpression() != null) {
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduling.getCronExpression());
            return this.createTriggerBuilder(uuid, (ScheduleBuilder<? extends Trigger>)cronScheduleBuilder);
        }
        if (scheduling.getDelay() != null) {
            SimpleScheduleBuilder simpleScheduleBuilder = times != 0 ? SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)times, (int)scheduling.getDelay()) : SimpleScheduleBuilder.repeatSecondlyForever((int)scheduling.getDelay());
            return this.createTriggerBuilder(uuid, (ScheduleBuilder<? extends Trigger>)simpleScheduleBuilder);
        }
        throw new LaunchException("Invalid Scheduling");
    }

    protected void reallySchedule(UUID uuid, LaunchParameter parameter) throws LaunchException, SchedulerException {
        JobKey jobKey = new JobKey(uuid.toString());
        JobDetail jobDetail = JobBuilder.newJob(SmartExecutorTask.class).withIdentity(jobKey).build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("UUID", (Object)uuid);
        jobDataMap.put("LAUNCH_PARAMETER", (Object)parameter);
        SecretManager secretManager = SecretManagerProvider.instance.get();
        Secret secret = (Secret)secretManager.getCurrentSecretHolder().getSecrets().first();
        String token = secret.getToken();
        jobDataMap.put("TOKEN", token);
        TriggerBuilder<? extends Trigger> triggerBuilder = TriggerBuilder.newTrigger().withIdentity(uuid.toString());
        Scheduling scheduling = parameter.getScheduling();
        if (scheduling != null) {
            try {
                logger.info("Going to schedule Taks with UUID {} with the following {} : {}", new Object[]{uuid, LaunchParameter.class.getSimpleName(), ExtendedSEMapper.getInstance().marshal(parameter)});
            }
            catch (Exception exception) {
                // empty catch block
            }
            triggerBuilder = this.getTriggerBuilderWithScheduling(uuid, scheduling);
            if (scheduling.getFirstStartTime() != null && scheduling.getFirstStartTime() != 0L) {
                Date triggerStartTime = new Date(scheduling.getFirstStartTime());
                triggerBuilder.startAt(triggerStartTime);
            }
            if (scheduling.getEndTime() != null && scheduling.getEndTime() != 0L) {
                Date triggerEndTime = new Date(scheduling.getEndTime());
                triggerBuilder.endAt(triggerEndTime);
            }
            try {
                ScheduledTaskPersistence stc = ScheduledTaskPersistenceFactory.getScheduledTaskPersistence();
                ScheduledTask scheduledTask = new ScheduledTask(uuid, parameter);
                logger.debug("Going to persist Scheduled Task {} ", (Object)scheduledTask);
                stc.addScheduledTask(scheduledTask);
            }
            catch (Exception e) {
                logger.error("Unable to persist Scheduled Task {}", (Object)uuid.toString(), (Object)e.getCause());
            }
        } else {
            try {
                logger.info("Starting Taks with UUID {} immediately with the following {} : {}", new Object[]{uuid, LaunchParameter.class.getSimpleName(), ExtendedSEMapper.getInstance().marshal(parameter)});
            }
            catch (Exception e) {
                // empty catch block
            }
            triggerBuilder.startNow();
        }
        try {
            SmartExecutorTaskListener sejl = new SmartExecutorTaskListener();
            this.scheduler.getListenerManager().addJobListener((JobListener)sejl);
            this.scheduler.scheduleJob(jobDetail, triggerBuilder.build());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized UUID schedule(LaunchParameter parameter, UUID uuid) throws InputsNullException, PluginNotFoundException, LaunchException {
        Map inputs = parameter.getInputs();
        if (inputs == null) {
            throw new InputsNullException();
        }
        try {
            PluginManager pluginManager = PluginManager.getInstance();
            pluginManager.getPlugin(parameter.getPluginName());
        }
        catch (PluginNotFoundException e) {
            throw e;
        }
        catch (ExecutorException e) {
            throw new LaunchException((Throwable)e);
        }
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        try {
            this.reallySchedule(uuid, parameter);
            this.scheduledJobs.add(uuid);
        }
        catch (SchedulerException e) {
            throw new LaunchException((Throwable)e);
        }
        return uuid;
    }

    protected void stopTask(UUID uuid) throws UnableToInterruptTaskException {
        JobKey jobKey = new JobKey(uuid.toString());
        try {
            logger.debug("Going to stop current SmartExecutor Task {} execution if any", (Object)uuid);
            if (!this.scheduler.checkExists(jobKey)) {
                logger.trace("SmartExecutor Task {} does not have any instaces associated. Cleaning the environment. That's all folk.", (Object)uuid);
                this.scheduledJobs.remove(uuid);
                throw new SchedulerNotFoundException("Scheduler Not Found");
            }
            boolean interrupted = this.scheduler.interrupt(jobKey);
            this.scheduler.deleteJob(jobKey);
            if (interrupted) {
                logger.debug("SmartExecutor Task {} interrupted successfully.", (Object)uuid);
            } else {
                logger.debug("SmartExecutor Task {} was not interrupted.", (Object)uuid);
            }
        }
        catch (Exception e) {
            throw new UnableToInterruptTaskException(uuid, (Throwable)e);
        }
    }

    protected List<JobExecutionContext> getCurrentlyExecutingJobs(Scheduler scheduler) throws SchedulerException {
        logger.trace("Getting {} list", (Object)JobExecutionContext.class.getSimpleName());
        List cej = scheduler.getCurrentlyExecutingJobs();
        logger.trace("{} list got {}", (Object)JobExecutionContext.class.getSimpleName(), (Object)cej);
        return cej;
    }

    public LaunchParameter getLaunchParameter(JobKey jobKey) throws SchedulerException {
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return null;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        return (LaunchParameter)jobDataMap.get((Object)"LAUNCH_PARAMETER");
    }

    public synchronized void stop(UUID uuid, boolean remove) throws Exception {
        JobKey jobKey = new JobKey(uuid.toString());
        LaunchParameter launchParameter = this.getLaunchParameter(jobKey);
        ScheduledTaskPersistence stc = ScheduledTaskPersistenceFactory.getScheduledTaskPersistence();
        if (launchParameter == null) {
            if (remove) {
                logger.debug("Going to remove the SmartExecutor Scheduled Task {} from global scheduling if any", (Object)uuid);
                try {
                    stc.removeScheduledTask(uuid);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PluginInstanceNotFoundException(uuid);
        }
        Scheduling scheduling = launchParameter.getScheduling();
        boolean scheduled = scheduling != null;
        this.stopTask(uuid);
        if (scheduled) {
            if (remove) {
                logger.debug("Going to remove the SmartExecutor Scheduled Task {} from global scheduling", (Object)uuid);
                stc.removeScheduledTask(uuid);
            } else if (scheduling.getGlobal().booleanValue()) {
                logger.debug("Going to release the SmartExecutor Scheduled Task {}. The Task can be take in charge from another SmartExecutor instance", (Object)uuid);
                stc.releaseScheduledTask(uuid);
            }
        }
    }

    public void stopAll() throws SchedulerException {
        ArrayList<UUID> set = new ArrayList<UUID>(this.scheduledJobs);
        for (UUID uuid : set) {
            try {
                this.stop(uuid, false);
            }
            catch (Exception e) {
                logger.error("Error stopping plugin instace with UUID {}", (Object)uuid, (Object)e);
            }
        }
        this.scheduler.clear();
        this.scheduler.shutdown();
        this.scheduler = null;
    }
}

