/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.ispublisher;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.publisher.is.legacy.Registry;
import org.gcube.common.core.publisher.is.legacy.stubs.RegistryStub;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.ispublisher.ISPublisher;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GCoreISPublisher
extends ISPublisher {
    private static Logger logger = LoggerFactory.getLogger(GCoreISPublisher.class);

    public GCoreISPublisher(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    private void publishResource(Resource resource) throws Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)resource, (Writer)stringWriter);
        Registry registry = new Registry();
        RegistryStub registryStubs = registry.getStubs();
        try {
            logger.debug("Trying to publish to {}:\n{}", (Object)SecretManagerProvider.get().getContext(), (Object)stringWriter);
            registryStubs.create(stringWriter.toString(), resource.type().toString());
        }
        catch (Exception e) {
            logger.error("The resource was not published", (Throwable)e);
            throw e;
        }
    }

    private void unPublishResource(Resource resource) throws Exception {
        Registry registry = new Registry();
        RegistryStub registryStubs = registry.getStubs();
        String id = resource.id();
        logger.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, SecretManagerProvider.get().getContext()});
        registryStubs.remove(id, resource.type().toString());
        logger.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    private short[] getVersionSlice(String version, int wantedLenght) {
        logger.trace("Trying to parse {}", (Object)version);
        short[] versionSlices = new short[wantedLenght];
        for (int j = 0; j < wantedLenght; ++j) {
            versionSlices[j] = (short)(j == 0 ? 1 : 0);
        }
        try {
            String[] stringSlices = version.split("[.-]");
            for (int i = 0; i < stringSlices.length; ++i) {
                logger.trace("Parsing version slice n. {} wich is '{}'", (Object)i, (Object)stringSlices[i]);
                if (i < wantedLenght) {
                    try {
                        short n;
                        versionSlices[i] = n = Short.parseShort(stringSlices[i]);
                        logger.trace("Version slice n. {} wich is '{}' parsed as short {}", new Object[]{i, stringSlices[i], n});
                    }
                    catch (NumberFormatException nfe) {
                        logger.trace("Version slice n. {} wich is '{}' failed to parse. The default value {} will be used", new Object[]{i, stringSlices[i], versionSlices[i]});
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.trace("Error parsing the supplied version the default will be used", (Object)versionSlices);
        }
        logger.trace("Version {} parsed as {}", (Object)version, (Object)versionSlices);
        return versionSlices;
    }

    private static String getRunningOn(ContainerConfiguration containerConfiguration) {
        return "%s:%s".formatted(containerConfiguration.hostname(), containerConfiguration.port());
    }

    protected ServiceEndpoint createServiceEndpoint(Map<String, Class<? extends Plugin>> availablePlugins) throws PluginNotFoundException, ExecutorException {
        logger.debug("Creating ServiceEndpoint to publish on IS available plugins and their own supported capabilities");
        ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        ServiceEndpoint.Profile profile = serviceEndpoint.newProfile();
        profile.category(applicationConfiguration.group());
        profile.name(applicationConfiguration.name());
        String version = applicationConfiguration.version();
        profile.version(version);
        profile.description(applicationConfiguration.description());
        String runningOn = GCoreISPublisher.getRunningOn((ContainerConfiguration)this.applicationContext.container().configuration());
        Platform platform = profile.newPlatform();
        platform.name(runningOn);
        short[] versionSlices = this.getVersionSlice(version, 4);
        platform.version(versionSlices[0]);
        platform.minorVersion(versionSlices[1]);
        platform.buildVersion(versionSlices[2]);
        platform.revisionVersion(versionSlices[3]);
        ServiceEndpoint.Runtime runtime = profile.newRuntime();
        runtime.hostedOn(runningOn);
        runtime.status(((ApplicationState)this.applicationContext.lifecycle().state()).remoteForm());
        Group accessPoints = profile.accessPoints();
        PluginManager pluginManager = PluginManager.getInstance();
        for (String pluginName : availablePlugins.keySet()) {
            ServiceEndpoint.AccessPoint accessPointElement = new ServiceEndpoint.AccessPoint();
            accessPointElement.name(pluginName);
            Plugin pluginDeclaration = pluginManager.getPlugin(pluginName);
            accessPointElement.description(pluginDeclaration.getDescription());
            Group properties = accessPointElement.properties();
            ServiceEndpoint.Property propertyVersionElement = new ServiceEndpoint.Property();
            propertyVersionElement.nameAndValue("Version", pluginDeclaration.getVersion());
            properties.add((Object)propertyVersionElement);
            Map pluginCapabilities = pluginDeclaration.getSupportedCapabilities();
            if (pluginCapabilities != null) {
                for (String capabilityName : pluginCapabilities.keySet()) {
                    ServiceEndpoint.Property propertyElement = new ServiceEndpoint.Property();
                    propertyElement.nameAndValue(capabilityName, (String)pluginCapabilities.get(capabilityName));
                    properties.add((Object)propertyElement);
                }
            }
            accessPoints.add((Object)accessPointElement);
        }
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)serviceEndpoint, (Writer)stringWriter);
        logger.debug("The created ServiceEndpoint profile is\n{}", (Object)stringWriter.toString());
        return serviceEndpoint;
    }

    protected void cleanServiceEndpoints() {
        try {
            ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
            ContainerContext containerContext = this.applicationContext.container();
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class).addCondition("$resource/Profile/Category/text() eq '%s'".formatted(applicationConfiguration.group())).addCondition("$resource/Profile/Name/text() eq '%s'".formatted(applicationConfiguration.name())).addCondition("$resource/Profile/RunTime/HostedOn/text() eq '%s'".formatted(GCoreISPublisher.getRunningOn((ContainerConfiguration)containerContext.configuration()))).setResult("$resource");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List serviceEndpoints = client.submit((Query)query);
            String context = SecretManagerProvider.get().getContext();
            for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
                try {
                    logger.debug("Trying to unpublish the old ServiceEndpoint with ID {} from scope {}", (Object)serviceEndpoint.id(), (Object)context);
                    this.unPublishResource((Resource)serviceEndpoint);
                }
                catch (Exception e) {
                    logger.debug("Exception tryng to unpublish the old ServiceEndpoint with ID {} from scope {}", new Object[]{serviceEndpoint.id(), context, e});
                }
            }
        }
        catch (Exception e) {
            logger.debug("An Exception occur while checking and/or unpublishing old ServiceEndpoint", (Throwable)e);
        }
    }

    public void publishPlugins(Map<String, Class<? extends Plugin>> availablePlugins) {
        try {
            ServiceEndpoint serviceEndpoint = this.createServiceEndpoint(availablePlugins);
            this.cleanServiceEndpoints();
            this.publishResource((Resource)serviceEndpoint);
        }
        catch (Exception e) {
            logger.error("Unable to Create ServiceEndpoint for scope {}. The Service will be aborted", (Object)SecretManagerProvider.get().getContext(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void unpublishPlugins(boolean force) throws Exception {
        this.cleanServiceEndpoints();
    }
}

