/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduledtask;

import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.common.core.publisher.is.legacy.application.ApplicationProfileBuilder;
import org.gcube.common.core.publisher.is.legacy.container.ContainerProfileBuilder;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.plugin.Ref;
import org.gcube.vremanagement.executor.plugin.RunOn;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ScheduledTask
extends org.gcube.vremanagement.executor.plugin.ScheduledTask {
    protected String context;
    protected String ownerId;
    public static final String LOCALHOST = "localhost";

    protected ScheduledTask() {
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter) throws Exception {
        this(uuid, launchParameter, ScheduledTask.generateRunOn());
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter, RunOn runOn) throws Exception {
        this.uuid = uuid;
        this.launchParameter = launchParameter;
        Secret secret = SecretManagerProvider.get();
        this.context = secret.getContext();
        this.ownerId = secret.getOwner().getId();
        this.runOn = runOn;
    }

    public String getContext() {
        return this.context;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public static RunOn generateRunOn() {
        ApplicationContext applicationContext = ContextProvider.get();
        Ref hostingNodeRef = null;
        try {
            ContainerProfileBuilder containerProfileBuilder = new ContainerProfileBuilder(applicationContext.container());
            HostingNode hostingNode = containerProfileBuilder.create();
            hostingNodeRef = new Ref(hostingNode.id(), hostingNode.profile().description().name());
        }
        catch (Exception e) {
            hostingNodeRef = new Ref("localhost", "localhost");
        }
        Ref eServiceRef = null;
        try {
            ApplicationProfileBuilder applicationProfileBuilder = new ApplicationProfileBuilder(applicationContext);
            GCoreEndpoint gCoreEndpoint = applicationProfileBuilder.create();
            String address = "";
            Group endpoints = gCoreEndpoint.profile().endpoints();
            for (GCoreEndpoint.Profile.Endpoint endpoint : endpoints) {
                if (endpoint.name().contains("remote-management")) continue;
                address = endpoint.uri().toString();
                break;
            }
            eServiceRef = new Ref(gCoreEndpoint.id(), address);
        }
        catch (Exception e) {
            eServiceRef = new Ref("localhost", "localhost");
        }
        RunOn runOn = new RunOn(hostingNodeRef, eServiceRef);
        return runOn;
    }

    public String toString() {
        try {
            return ExtendedSEMapper.getInstance().marshal((Object)this);
        }
        catch (Exception e) {
            return "ScheduledTask [context=" + this.context + ", ownerId=" + this.ownerId + ", uuid=" + String.valueOf(this.uuid) + ", launchParameter=" + String.valueOf(this.launchParameter) + ", runOn=" + String.valueOf(this.runOn) + "]";
        }
    }
}

