/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.AggregationRowConfig;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.HeaderGroupConfig;
import com.extjs.gxt.ui.client.widget.grid.SummaryType;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesView;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.GridField;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.Util;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;

public class SpeciesGrid
extends ContentPanel
implements SpeciesView {
    private Grid<ModelData> grid;
    protected CheckBoxSelectionModel<ModelData> selectionModel;

    public SpeciesGrid(ListStore<ModelData> store) {
        this.setLayout((Layout)new AnchorLayout());
        this.setHeaderVisible(false);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        this.selectionModel = new CheckBoxSelectionModel();
        this.selectionModel.setSelectionMode(Style.SelectionMode.MULTI);
        columns.add(this.selectionModel.getColumn());
        ColumnConfig dataSource = Util.createColumnConfig((GridField)SpeciesGridFields.DATASOURCE, (int)100);
        columns.add(dataSource);
        ColumnConfig dataProvider = Util.createColumnConfig((GridField)SpeciesGridFields.DATAPROVIDER, (int)310);
        columns.add(dataProvider);
        ColumnConfig dataSet = Util.createColumnConfig((GridField)SpeciesGridFields.DATASET, (int)360);
        columns.add(dataSet);
        ColumnConfig dataSetCitation = Util.createColumnConfig((GridField)SpeciesGridFields.DATASET_CITATION, (int)360);
        dataSetCitation.setHidden(true);
        columns.add(dataSetCitation);
        ColumnConfig matchingName = Util.createColumnConfig((GridField)SpeciesGridFields.MATCHING_NAME, (int)180);
        columns.add(matchingName);
        ColumnConfig accordingTo = Util.createColumnConfig((GridField)SpeciesGridFields.MATCHING_AUTHOR, (int)220);
        columns.add(accordingTo);
        ColumnConfig matchingCategory = Util.createColumnConfig((GridField)SpeciesGridFields.MATCHING_RANK, (int)80);
        columns.add(matchingCategory);
        ColumnConfig matchingCredits = Util.createColumnConfig((GridField)SpeciesGridFields.MATCHING_CREDITS, (int)80);
        matchingCredits.setHidden(true);
        columns.add(matchingCredits);
        columns.add(Util.createColumnConfig((GridField)SpeciesGridFields.PRODUCT_IMAGES, (int)75));
        columns.add(Util.createColumnConfig((GridField)SpeciesGridFields.PRODUCT_MAPS, (int)75));
        columns.add(Util.createColumnConfig((GridField)SpeciesGridFields.PRODUCT_LAYERS, (int)75));
        columns.add(Util.createColumnConfig((GridField)SpeciesGridFields.PRODUCT_OCCURRENCES, (int)75));
        columns.add(Util.createColumnConfig((GridField)SpeciesGridFields.PRODUCT_SPECIMENS, (int)75));
        ColumnConfig classification = Util.createColumnConfig((GridField)SpeciesGridFields.CLASSIFICATION_STRING, (int)1240);
        columns.add(classification);
        ColumnModel classicColumnModel = new ColumnModel(columns);
        classicColumnModel.addHeaderGroup(0, 1, new HeaderGroupConfig(SpeciesGridFields.PROVENANCE.getName(), 1, 3));
        classicColumnModel.addHeaderGroup(0, 4, new HeaderGroupConfig("Matching", 1, 4));
        classicColumnModel.addHeaderGroup(0, 8, new HeaderGroupConfig(SpeciesGridFields.PRODUCTS.getName(), 1, 6));
        AggregationRowConfig counts = new AggregationRowConfig();
        counts.setHtml(SpeciesGridFields.DATASOURCE.getId(), "Count");
        counts.setSummaryType(SpeciesGridFields.PRODUCT_IMAGES.getId(), SummaryType.SUM);
        counts.setSummaryFormat(SpeciesGridFields.PRODUCT_IMAGES.getId(), NumberFormat.getDecimalFormat());
        counts.setSummaryType(SpeciesGridFields.PRODUCT_MAPS.getId(), SummaryType.SUM);
        counts.setSummaryFormat(SpeciesGridFields.PRODUCT_MAPS.getId(), NumberFormat.getDecimalFormat());
        counts.setSummaryType(SpeciesGridFields.PRODUCT_LAYERS.getId(), SummaryType.SUM);
        counts.setSummaryFormat(SpeciesGridFields.PRODUCT_LAYERS.getId(), NumberFormat.getDecimalFormat());
        counts.setSummaryType(SpeciesGridFields.PRODUCT_OCCURRENCES.getId(), SummaryType.SUM);
        counts.setSummaryFormat(SpeciesGridFields.PRODUCT_OCCURRENCES.getId(), NumberFormat.getDecimalFormat());
        counts.setSummaryType(SpeciesGridFields.PRODUCT_SPECIMENS.getId(), SummaryType.SUM);
        counts.setSummaryFormat(SpeciesGridFields.PRODUCT_SPECIMENS.getId(), NumberFormat.getDecimalFormat());
        classicColumnModel.addAggregationRow(counts);
        this.grid = new Grid(store, classicColumnModel);
        this.grid.setLoadMask(true);
        this.grid.setBorders(true);
        this.grid.setStripeRows(true);
        this.grid.setSelectionModel((GridSelectionModel)this.selectionModel);
        this.grid.addPlugin((ComponentPlugin)this.selectionModel);
        this.add((Widget)this.grid, (LayoutData)new AnchorData("100% 100%"));
    }

    protected void onShow() {
        super.onShow();
        this.reload();
    }

    public void reload() {
    }

    public List<ResultRow> getSelectedRows() {
        LinkedList<ResultRow> selectedRows = new LinkedList<ResultRow>();
        for (ModelData selected : this.selectionModel.getSelectedItems()) {
            selectedRows.add((ResultRow)selected.get(SpeciesGridFields.ROW.getId()));
        }
        return selectedRows;
    }
}

