/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import net.sf.csv4j.CSVWriter;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.rpc.TaxonomySearchService;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.GBIFServiceClient;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.common.Fetcher;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.common.FetchingSession;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.datasource.DataSourceManager;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.service.SpeciesServiceTaxonomy;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.Converter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.OccurenceConverter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.ResultConverter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.ResultIterator;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.TaxonomyService;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.DataSourceInfo;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Occurrence;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.OccurrenceBatch;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.SearchFilters;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.SearchResult;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.SearchServiceException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class TaxonomySearchServiceImpl
extends RemoteServiceServlet
implements TaxonomySearchService {
    private static final long serialVersionUID = -287193068445844326L;
    protected static final long MAX_BUFFERING_TIME = 1000L;
    protected static final long BUFFER_LIMIT = 10L;
    protected static Map<String, FetchingSession<?>> fetchingSessions = new LinkedHashMap();
    public static final String USERNAME_ATTRIBUTE = "username";
    protected Logger logger = Logger.getLogger((String)"TaxonomySearchService");

    static {
        Logger root = Logger.getLogger((String)"org.gcube.application.speciesmanagement.speciesdiscovery");
        root.setLevel(Level.ALL);
        root.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
    }

    protected ASLSession getASLSession(HttpSession httpSession) {
        String sessionID = httpSession.getId();
        String user = (String)httpSession.getAttribute(USERNAME_ATTRIBUTE);
        if (user == null) {
            this.logger.error((Object)"TaxonomySearchServiceImpl STARTING IN TEST MODE - NO USER FOUND");
            user = "test.user";
            httpSession.setAttribute(USERNAME_ATTRIBUTE, (Object)user);
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
            session.setScope("/gcube/devsec");
            return session;
        }
        this.logger.trace((Object)("user found in session " + user));
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    protected GCUBEScope getScope() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        ASLSession session = this.getASLSession(httpSession);
        return session.getScope();
    }

    protected TaxonomyService getTaxonomyService() {
        GCUBEScope scope = this.getScope();
        return new SpeciesServiceTaxonomy(scope);
    }

    public List<DataSourceInfo> getAvailableDataSources() throws SearchServiceException {
        return DataSourceManager.getInstance().getAvailableDataSourceForTaxonomy();
    }

    public String searchByScientificName(String searchTerm, SearchFilters searchFilters) throws SearchServiceException {
        System.out.println("searchTerm: " + searchTerm);
        try {
            TaxonomyService taxonomyService = this.getTaxonomyService();
            ResultIterator result = taxonomyService.searchByScientificName(searchTerm, searchFilters);
            String id = this.createFetchingSession(result);
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    public SearchResult getResultRow(String searchId) throws SearchServiceException {
        System.out.println("searchId: " + searchId);
        if (this.isComplete(searchId)) {
            SearchResult result = new SearchResult();
            result.setResultEOF(true);
            return result;
        }
        ArrayList buffer = this.getFetched(searchId);
        SearchResult result = new SearchResult(buffer);
        result.setResultEOF(this.isComplete(searchId));
        return result;
    }

    public List<Occurrence> getOccurrences(String providerId, String datasetId, String taxonId, String taxonName) throws SearchServiceException {
        try {
            return GBIFServiceClient.getOccurences((String)providerId, (String)datasetId, (String)taxonId, (String)taxonName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    public String searchByCommonName(String searchTerm, SearchFilters searchFilters) throws SearchServiceException {
        System.out.println("searchTerm: " + searchTerm);
        try {
            TaxonomyService taxonomyService = this.getTaxonomyService();
            ResultIterator result = taxonomyService.searchByCommonName(searchTerm, searchFilters);
            String id = this.createFetchingSession(result);
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    public String generateMapFromOccurrences(List<String> keys) throws SearchServiceException {
        System.out.println("generateMapFromOccurrences keys: " + keys);
        try {
            TaxonomyService taxonomyService = this.getTaxonomyService();
            String groupName = taxonomyService.getOccurrencesMap(keys);
            return groupName;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    public String retrieveOccurences(List<String> keys) throws SearchServiceException {
        System.out.println("retrieveOccurences keys: " + keys);
        try {
            TaxonomyService taxonomyService = this.getTaxonomyService();
            ResultIterator result = taxonomyService.getOccurrences(keys);
            String id = this.createFetchingSession(result);
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    public OccurrenceBatch getOccurrencesBatch(String id) throws SearchServiceException {
        System.out.println("getOccurrencesBatch: " + id);
        if (this.isComplete(id)) {
            OccurrenceBatch batch = new OccurrenceBatch();
            batch.setResultEOF(true);
            return batch;
        }
        ArrayList buffer = this.getFetched(id);
        OccurrenceBatch result = new OccurrenceBatch(buffer);
        result.setResultEOF(this.isComplete(id));
        return result;
    }

    protected <T> String createFetchingSession(ResultIterator<T> iterator) {
        FetchingSession searchSession = new FetchingSession();
        String id = UUID.randomUUID().toString();
        Fetcher fetcher = new Fetcher(iterator);
        searchSession.addFetcherAndRun(fetcher);
        fetchingSessions.put(id, searchSession);
        return id;
    }

    protected <T> ArrayList<T> getFetched(String id) throws SearchServiceException {
        FetchingSession session = (FetchingSession)fetchingSessions.get(id);
        if (session == null) {
            return new ArrayList();
        }
        long startTime = System.currentTimeMillis();
        ArrayList buffer = new ArrayList();
        long timeout = 1000L;
        try {
            do {
                Object result;
                if ((result = session.getQueue().poll(timeout, TimeUnit.MILLISECONDS)) == null) continue;
                buffer.add(result);
            } while ((timeout = Math.max(0L, 1000L - (System.currentTimeMillis() - startTime))) > 0L && (long)buffer.size() < 10L);
            return buffer;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    protected boolean isComplete(String id) {
        FetchingSession session = (FetchingSession)fetchingSessions.get(id);
        if (session == null) {
            return true;
        }
        boolean complete = session.isComplete();
        if (complete) {
            this.removeFetchSession(id);
        }
        return complete;
    }

    protected void removeFetchSession(String id) {
        fetchingSessions.remove(id);
    }

    public void saveOccurrences(List<String> keys, String destinationFolderId, String name) throws SearchServiceException {
        try {
            File file = File.createTempFile("test", ".csv");
            System.out.println("outputfile " + file.getAbsolutePath());
            FileWriter fileWriter = new FileWriter(file);
            CSVWriter writer = new CSVWriter((Writer)fileWriter);
            TaxonomyService taxonomyService = this.getTaxonomyService();
            ResultIterator result = taxonomyService.getOccurrences(keys);
            OccurenceConverter converter = new OccurenceConverter();
            ResultConverter occurrencesConverter = new ResultConverter(result, (Converter)converter);
            while (occurrencesConverter.hasNext()) {
                writer.writeLine((List)occurrencesConverter.next());
            }
            fileWriter.close();
            Workspace workspace = HomeLibrary.getUserWorkspace((ASLSession)this.getASLSession(this.getThreadLocalRequest().getSession()));
            WorkspaceFolder folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
            name = WorkspaceUtil.getUniqueName((String)name, (WorkspaceFolder)folder);
            folder.createExternalFileItem(name, "Occurrence points generated files", "text/csv", (InputStream)new FileInputStream(file));
            file.delete();
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }
}

