/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client.old;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.GridField;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.OccurencesGridFields;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.Util;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Occurrence;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;

public class OccurencesWindow
extends Window {
    protected GroupingStore<BaseModelData> store;

    public OccurencesWindow() {
        this.setHeading("Occurence points");
        this.setLayout((Layout)new FitLayout());
        this.setModal(true);
        this.setResizable(true);
        this.setSize(1200, 500);
        this.store = new GroupingStore();
        this.store.groupBy("dataprovider");
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        ColumnConfig dataSet = Util.createColumnConfig((GridField)OccurencesGridFields.DATASET, (int)360);
        config.add(dataSet);
        ColumnConfig matchingName = Util.createColumnConfig((GridField)OccurencesGridFields.MATCHING_NAME, (int)180);
        config.add(matchingName);
        ColumnConfig accordingTo = Util.createColumnConfig((GridField)OccurencesGridFields.MATCHING_AUTHOR, (int)220);
        config.add(accordingTo);
        ColumnConfig latitudeColumn = Util.createColumnConfig((GridField)OccurencesGridFields.LATITUDE, (int)150);
        config.add(latitudeColumn);
        ColumnConfig longitudeColumn = Util.createColumnConfig((GridField)OccurencesGridFields.LONGITUDE, (int)150);
        config.add(longitudeColumn);
        ColumnConfig catalogNumberColumn = Util.createColumnConfig((GridField)OccurencesGridFields.CATALOG_NUMBER, (int)150);
        config.add(catalogNumberColumn);
        ColumnConfig countryColumn = Util.createColumnConfig((GridField)OccurencesGridFields.COUNTRY, (int)150);
        config.add(countryColumn);
        ColumnConfig earliestDateCollectedColumn = Util.createColumnConfig((GridField)OccurencesGridFields.EARLIEST_DATE_COLLECTED, (int)150);
        config.add(earliestDateCollectedColumn);
        ColumnConfig latestDateCollectedColumn = Util.createColumnConfig((GridField)OccurencesGridFields.LATEST_DATE_COLLECTED, (int)150);
        config.add(latestDateCollectedColumn);
        ColumnModel cm = new ColumnModel(config);
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        Grid grid = new Grid((ListStore)this.store, cm);
        grid.setView((GridView)view);
        grid.setBorders(true);
        this.add((Component)grid);
    }

    public void loadOccurencePoints(List<ResultRow> results) {
        this.store.removeAll();
        this.loadOccurences(results);
    }

    protected void loadOccurences(List<ResultRow> results) {
        if (results.size() == 0) {
            return;
        }
        ResultRow result = results.remove(0);
        Log.trace((String)("Retrieving occurences for " + result));
        SpeciesDiscovery.taxonomySearchService.getOccurrences(result.getDataProviderId(), result.getDataSetId(), result.getMatchingTaxon().getId(), result.getMatchingTaxon().getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected BaseModelData convertToData(String dataProvider, String dataSet, String matchingName, String matchingCategory, Occurrence occurence) {
        BaseModelData data = new BaseModelData();
        data.set("dataprovider", (Object)dataProvider);
        data.set("dataset", (Object)dataSet);
        data.set("matchingName", (Object)matchingName);
        data.set("matchingRank", (Object)matchingCategory);
        data.set(OccurencesGridFields.LATITUDE.getId(), (Object)occurence.getLatitude());
        data.set(OccurencesGridFields.LONGITUDE.getId(), (Object)occurence.getLongitude());
        data.set(OccurencesGridFields.CATALOG_NUMBER.getId(), (Object)occurence.getCatalogNumber());
        data.set(OccurencesGridFields.COUNTRY.getId(), (Object)occurence.getCountry());
        data.set(OccurencesGridFields.EARLIEST_DATE_COLLECTED.getId(), (Object)occurence.getEarliestDateCollected());
        data.set(OccurencesGridFields.LATEST_DATE_COLLECTED.getId(), (Object)occurence.getLatestDateCollected());
        return data;
    }
}

