/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client.old;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.old.OccurencesWindow;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.old.SearchPanelOld;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.resources.Resources;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.rpc.TaxonomySearchService;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.rpc.TaxonomySearchServiceAsync;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.DataSourceInfo;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Taxon;

public class SearchPanelOld
extends ContentPanel {
    protected static final String COMMON_NAME = "Common name";
    protected static final String SCIENTIFIC_NAME = "Scientific name";
    protected TaxonomySearchServiceAsync service = (TaxonomySearchServiceAsync)GWT.create(TaxonomySearchService.class);
    private String checkedStyle = "x-grid3-group-check";
    private String uncheckedStyle = "x-grid3-group-uncheck";
    private GroupingStore<BaseModelData> store;
    private Grid<BaseModelData> resultGrid;
    protected GroupingView view;
    private Image loadingImage;
    protected CheckBoxSelectionModel<BaseModelData> selectionModel;
    protected FieldSet advancedPanel;
    protected Map<String, DataSourceInfo> datasources = new LinkedHashMap();
    protected CheckBoxGroup checkGroupDataSource;
    protected HorizontalPanel searchPanel;
    private SimpleComboBox<String> searchType;
    protected Button searchButton;

    public SearchPanelOld() {
        this.setLayout((Layout)new AnchorLayout());
        this.setFrame(false);
        this.setHeaderVisible(false);
        this.setId("MYPANEL");
        this.searchPanel = new HorizontalPanel();
        this.searchPanel.setSpacing(5);
        this.searchType = new SimpleComboBox();
        this.searchType.add(Arrays.asList(SCIENTIFIC_NAME, COMMON_NAME));
        this.searchType.setEditable(false);
        this.searchType.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.searchType.setSimpleValue((Object)SCIENTIFIC_NAME);
        this.searchPanel.add((Widget)this.searchType);
        this.searchPanel.add((Widget)new Label(":"));
        TextField searchField = new TextField();
        searchField.setWidth(200);
        this.searchPanel.add((Widget)searchField);
        this.searchButton = new Button("Search", (SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchPanel.add((Widget)this.searchButton);
        this.searchPanel.add((Widget)new Button("Example", (SelectionListener)new /* Unavailable Anonymous Inner Class!! */));
        this.loadingImage = new Image(Resources.INSTANCE.loadingBalls());
        this.loadingImage.setVisible(false);
        this.searchPanel.add((Widget)this.loadingImage);
        this.add((Widget)this.searchPanel, (LayoutData)new AnchorData("100%", new Margins(5)));
        this.loadDataSources();
        this.store = new GroupingStore();
        this.store.groupBy("datasource");
        this.selectionModel = new /* Unavailable Anonymous Inner Class!! */;
        ColumnConfig dataSource = new ColumnConfig("datasource", "Data Source", 360);
        ColumnConfig dataProvider = new ColumnConfig("dataprovider", "Data Provider", 360);
        ColumnConfig dataSet = new ColumnConfig("dataset", "Data Set", 360);
        ColumnConfig dataSetCitation = new ColumnConfig("datasetCitation", "Data Set Citation", 360);
        dataSetCitation.setHidden(true);
        ColumnConfig productType = new ColumnConfig("producttype", "Product Type", 360);
        ColumnConfig matchingName = new ColumnConfig("matchingName", "Matching Name", 220);
        ColumnConfig accordingTo = new ColumnConfig("accordingTo", "According to", 220);
        ColumnConfig matchingCategory = new ColumnConfig("matchingRank", "Matching Rank", 120);
        ColumnConfig classification = new ColumnConfig("classification", "Classification", 1240);
        classification.setId("classification");
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        config.add(this.selectionModel.getColumn());
        config.add(dataSource);
        config.add(dataProvider);
        config.add(dataSet);
        config.add(dataSetCitation);
        config.add(productType);
        config.add(matchingName);
        config.add(accordingTo);
        config.add(matchingCategory);
        config.add(classification);
        ColumnModel cm = new ColumnModel(config);
        this.view = new /* Unavailable Anonymous Inner Class!! */;
        this.view.setShowGroupedColumn(false);
        this.view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.view.setShowGroupedColumn(false);
        this.view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.resultGrid = new Grid((ListStore)this.store, cm);
        this.resultGrid.setTitle("Results:");
        this.resultGrid.setView((GridView)this.view);
        this.resultGrid.setSelectionModel((GridSelectionModel)this.selectionModel);
        this.selectionModel.setSelectionMode(Style.SelectionMode.MULTI);
        this.resultGrid.setHeight(500);
        this.resultGrid.setBorders(true);
        this.add((Widget)this.resultGrid, (LayoutData)new AnchorData("100% -20", new Margins(10)));
    }

    protected void openOccurencesWindow() {
        LinkedList<ResultRow> selectedRows = new LinkedList<ResultRow>();
        for (BaseModelData selected : this.selectionModel.getSelectedItems()) {
            selectedRows.add((ResultRow)selected.get("resultRow"));
        }
        OccurencesWindow occurencesWindow = new OccurencesWindow();
        occurencesWindow.loadOccurencePoints(selectedRows);
        occurencesWindow.show();
    }

    protected void loadDataSources() {
        this.service.getAvailableDataSources((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void search(String searchTerm) {
        this.resultGrid.mask("Searching...");
        this.searchButton.setEnabled(false);
        this.store.removeAll();
        8 callback = new /* Unavailable Anonymous Inner Class!! */;
        if (SCIENTIFIC_NAME.equals(this.searchType.getSimpleValue())) {
            this.service.searchByScientificName(searchTerm, null, (AsyncCallback)callback);
        }
        if (COMMON_NAME.equals(this.searchType.getSimpleValue())) {
            this.service.searchByCommonName(searchTerm, null, (AsyncCallback)callback);
        }
    }

    protected void getSearchData(String searchId) {
        this.service.getResultRow(searchId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void loadData(ArrayList<ResultRow> rows) {
        for (ResultRow row : rows) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("datasource", row.getDataSourceName());
            properties.put("dataprovider", row.getDataProviderName());
            properties.put("dataset", row.getDataSetName());
            properties.put("datasetCitation", row.getDataSetCitation());
            properties.put("matchingName", row.getMatchingTaxon().getName());
            properties.put("accordingTo", row.getMatchingTaxon().getAccordingTo());
            properties.put("matchingRank", row.getMatchingTaxon().getRank());
            properties.put("classification", this.getClassification(row.getMatchingTaxon()));
            properties.put("resultRow", (String)row);
            BaseModelData data = new BaseModelData(properties);
            this.store.add((ModelData)data);
        }
    }

    protected String getClassification(Taxon taxon) {
        StringBuilder sb = new StringBuilder();
        if (taxon.getParent() != null) {
            sb.append(this.getClassification(taxon.getParent()));
            sb.append(" -> ");
        }
        sb.append("<b>");
        sb.append(taxon.getRank());
        sb.append("</b>: ");
        sb.append(taxon.getName());
        return sb.toString();
    }

    private El findCheck(Element group) {
        try {
            return El.fly((Element)group).selectNode(".x-grid3-group-checker").firstChild();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setGroupChecked(Element group, boolean checked) {
        El el = this.findCheck(group);
        if (el != null) {
            el.replaceStyleName(checked ? this.uncheckedStyle : this.checkedStyle, checked ? this.checkedStyle : this.uncheckedStyle);
        }
    }

    static /* synthetic */ void access$0(SearchPanelOld searchPanelOld, Element element, boolean bl) {
        searchPanelOld.setGroupChecked(element, bl);
    }

    static /* synthetic */ String access$1(SearchPanelOld searchPanelOld) {
        return searchPanelOld.uncheckedStyle;
    }

    static /* synthetic */ String access$2(SearchPanelOld searchPanelOld) {
        return searchPanelOld.checkedStyle;
    }

    static /* synthetic */ Grid access$3(SearchPanelOld searchPanelOld) {
        return searchPanelOld.resultGrid;
    }

    static /* synthetic */ Image access$4(SearchPanelOld searchPanelOld) {
        return searchPanelOld.loadingImage;
    }
}

