/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.server.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.service.OccurrenceConverter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.service.SpeciesServiceConverter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.Converter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.IteratorWrapper;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.ResultConverter;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.ResultIterator;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.taxonomy.TaxonomyService;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Occurrence;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.SearchFilters;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.SearchServiceException;
import org.gcube.application.speciesmanager.stubs.calls.ManagerCalls;
import org.gcube.application.speciesmanager.stubs.calls.OccurrencesCall;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Coordinate;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Properties;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.readers.OccurrencesReader;
import org.gcube.application.speciesmanager.stubs.writers.RSWrapper;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;

public class SpeciesServiceTaxonomy
implements TaxonomyService {
    protected Logger logger = Logger.getLogger(SpeciesServiceConverter.class);
    protected ManagerCalls call;
    protected OccurrencesCall occurrencesCall;
    protected GCUBEScope scope;

    public SpeciesServiceTaxonomy(GCUBEScope scope) {
        try {
            this.scope = scope;
            this.call = new ManagerCalls(scope, new GCUBESecurityManager[0]);
            this.occurrencesCall = new OccurrencesCall(scope, new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResultIterator<ResultRow> searchByScientificName(String searchTerm, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByScientificName: " + searchTerm + " usearchFilters: " + searchFilters));
        try {
            List properties = this.createFilterProperties(searchFilters);
            Iterator it = this.call.searchByScientificName(searchTerm, properties.toArray(new Property[properties.size()]));
            return this.createResultIterator(it);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public ResultIterator<ResultRow> searchByCommonName(String searchTerm, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByCommonName: " + searchTerm + " searchFilters: " + searchFilters));
        try {
            List properties = this.createFilterProperties(searchFilters);
            Iterator it = this.call.searchByCommonName(searchTerm, properties.toArray(new Property[properties.size()]));
            return this.createResultIterator(it);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    protected List<Property> createFilterProperties(SearchFilters searchFilters) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (searchFilters.getUpperBound() != null) {
            properties.add(new Property(Properties.CoordinateTo, (Object)this.convert(searchFilters.getUpperBound())));
        }
        if (searchFilters.getLowerBound() != null) {
            properties.add(new Property(Properties.CoordinateFrom, (Object)this.convert(searchFilters.getLowerBound())));
        }
        if (searchFilters.getFromDate() != null) {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTime(searchFilters.getFromDate());
            properties.add(new Property(Properties.DateFrom, (Object)fromDate));
        }
        if (searchFilters.getToDate() != null) {
            Calendar toDate = Calendar.getInstance();
            toDate.setTime(searchFilters.getToDate());
            properties.add(new Property(Properties.DateTo, (Object)toDate));
        }
        return properties;
    }

    protected ResultIterator<ResultRow> createResultIterator(Iterator<ResultItem> iterator) throws Exception {
        IteratorWrapper source = new IteratorWrapper(iterator);
        SpeciesServiceConverter converter = new SpeciesServiceConverter("");
        ResultConverter resultsConverter = new ResultConverter((ResultIterator)source, (Converter)converter);
        return resultsConverter;
    }

    public ResultIterator<ResultRow> searchByScientificName(String datasourceId, String searchTerm) throws SearchServiceException {
        return null;
    }

    public ResultIterator<ResultRow> searchByCommonName(String datasourceId, String searchTerm) throws SearchServiceException {
        return null;
    }

    protected Coordinate convert(org.gcube.application.speciesmanagement.speciesdiscovery.shared.Coordinate coordinate) {
        return new Coordinate((double)coordinate.getLatitude(), (double)coordinate.getLongitude());
    }

    public ResultIterator<Occurrence> getOccurrences(List<String> keys) throws SearchServiceException {
        try {
            RSWrapper wrapper = new RSWrapper(this.scope);
            OccurrencesReader reader = this.occurrencesCall.getByIds(wrapper.getLocator().toString());
            for (String key : keys) {
                wrapper.add(key);
            }
            wrapper.close();
            OccurrenceConverter converter = new OccurrenceConverter();
            return new ResultConverter((ResultIterator)new IteratorWrapper((Iterator)reader), (Converter)converter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public String getOccurrencesMap(List<String> keys) throws SearchServiceException {
        try {
            RSWrapper wrapper = new RSWrapper(this.scope);
            for (String key : keys) {
                wrapper.add(key);
            }
            wrapper.close();
            return this.occurrencesCall.getLayerByIds(wrapper.getLocator().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }
}

