/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.viewer.server;

import com.google.gwt.benchmarks.viewer.client.Category;
import com.google.gwt.benchmarks.viewer.client.Report;
import com.google.gwt.benchmarks.viewer.server.CategoryXml;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
class ReportXml {
    ReportXml() {
    }

    public static Report fromXml(Element element) {
        Report report = new Report();
        String dateString = element.getAttribute("date");
        try {
            DateFormat format = DateFormat.getDateTimeInstance();
            Date d = format.parse(dateString);
            report.setDate(d);
            report.setDateString(format.format(d));
        }
        catch (ParseException e) {
            // empty catch block
        }
        report.setGwtVersion(element.getAttribute("gwt_version"));
        List children = ReportXml.getElementChildren((Element)element, (String)"category");
        HashMap<String, Category> categories = new HashMap<String, Category>();
        for (Element child : children) {
            Category newCategory = CategoryXml.fromXml((Element)child);
            Category oldCategory = (Category)categories.get(newCategory.getName());
            if (oldCategory != null) {
                oldCategory.getBenchmarks().addAll(newCategory.getBenchmarks());
                continue;
            }
            categories.put(newCategory.getName(), newCategory);
        }
        report.setCategories(new ArrayList(categories.values()));
        return report;
    }

    static Element getElementChild(Element e, String name) {
        NodeList children = e.getElementsByTagName(name);
        return children.getLength() == 0 ? null : (Element)children.item(0);
    }

    static List<Element> getElementChildren(Element e, String name) {
        NodeList children = e.getElementsByTagName(name);
        int numElements = children.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(numElements);
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            elements.add((Element)n);
        }
        return elements;
    }

    static String getText(Element e) {
        Node n = e.getFirstChild();
        return n == null ? null : n.getNodeValue();
    }
}

