/*
 * Decompiled with CFR 0.152.
 */
package org.grade.engine;

import com.hp.hpl.jena.rdf.model.Model;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import lombok.NonNull;
import org.grade.common.GradeConstants;
import org.grade.common.GradeUtils;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.EndpointConfiguration;
import org.grade.configuration.GraphConfiguration;
import org.grade.engine.TaskExecution;
import org.grade.repo.Endpoint;
import org.grade.repo.GenericRepository;
import org.grade.repo.Task;
import org.grade.repo.impl.DefaultEndpoint;
import org.grade.repo.impl.memory.MemoryEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TaskEngine {
    private static final Logger log = LoggerFactory.getLogger(TaskEngine.class);
    @Inject
    @Qualifiers.Production
    GenericRepository production;
    @Inject
    @Qualifiers.Staging
    GenericRepository staging;
    private Map<String, TaskExecution> dryrunning = new LinkedHashMap<String, TaskExecution>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TaskExecution> eldest) {
            TaskExecution execution = eldest.getValue();
            boolean outcome = TaskEngine.this.removeEldest(execution, this.size());
            if (outcome) {
                log.trace("evicting sandboxed execution '{}''", (Object)execution.task().label());
                this.remove(execution.id());
            }
            return outcome;
        }
    };
    private Map<String, TaskExecution> running = new LinkedHashMap<String, TaskExecution>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TaskExecution> eldest) {
            TaskExecution execution = eldest.getValue();
            boolean outcome = TaskEngine.this.removeEldest(execution, this.size());
            if (outcome) {
                log.trace("evicting standard execution of '{}''", (Object)execution.task().label());
                this.remove(execution.id());
            }
            return outcome;
        }
    };

    public TaskExecution lookup(@NonNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        TaskExecution execution = this.running.get(id);
        if (execution == null) {
            execution = this.dryrunning.get(id);
        }
        if (execution == null) {
            throw new IllegalStateException("no running execution " + id);
        }
        return execution;
    }

    public void remove(@NonNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        TaskExecution execution = this.running.remove(id);
        if (execution == null) {
            execution = this.dryrunning.remove(id);
        }
        if (execution == null) {
            log.warn("execution {} cannot be removed as it does not exist", (Object)id);
        } else {
            execution.dispose();
            log.trace("removed {} execution of '{}'", (Object)(execution.dryrun() ? "sandboxed" : "standard"), (Object)execution.task().label());
        }
    }

    public TaskExecution dryExecute(@NonNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        return this.$execute(task, true);
    }

    public TaskExecution execute(@NonNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        return this.$execute(task, false);
    }

    private TaskExecution $execute(@NonNull Task task, boolean dryrun) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        try {
            Endpoint source = this.resolveSourceFor(task);
            Endpoint target = this.resolveTargetFor(task);
            if (task.operation() != Task.Operation.publish && !target.exists(task.targetGraph())) {
                throw new IllegalArgumentException("invalid task: operation is " + task.operation() + " yet target graph " + task.targetGraph() + " does not exist");
            }
            if (dryrun) {
                target = this.sandboxFor(task, source, target);
            }
            TaskExecution execution = new TaskExecution(task, dryrun);
            if (dryrun) {
                this.dryrunning.put(execution.id(), execution);
            } else {
                this.running.put(execution.id(), execution);
            }
            execution.start(source, target);
            return execution;
        }
        catch (Exception e) {
            throw GradeUtils.unchecked((String)("cannot execute '" + task.label() + "'"), (Throwable)e);
        }
    }

    private Endpoint sandboxFor(Task task, Endpoint source, Endpoint target) {
        log.info("[executing '{}']: creating sandbox for executing '{}' @ {}", new Object[]{task.label(), task.targetEndpoint(), task.targetGraph()});
        MemoryEndpoint sandbox = new MemoryEndpoint(target.configuration().name() + " (sandbox)");
        if (task.operation() != Task.Operation.publish) {
            Model model = target.get(task.targetGraph());
            sandbox.create(GraphConfiguration.graph((String)task.targetGraph()), model);
        }
        return sandbox;
    }

    private Endpoint resolveSourceFor(Task task) {
        String key = task.sourceEndpoint();
        Endpoint ep = this.staging.endpoints().resolveIfExists(key).orElseGet(() -> this.production.endpoints().resolveIfExists(key).orElseGet(() -> {
            try {
                GradeUtils.validUri((String)"source endpoint", (String)key);
                log.warn("unresolved source endpoint, using directly {}", (Object)key);
                return new DefaultEndpoint(EndpointConfiguration.endpoint((String)key, (String)key));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot resolve or use source endpoint " + key);
            }
        }));
        log.info("[executing '{}']: resolved source endpoint to '{}'", (Object)task.label(), (Object)ep.configuration().name());
        return ep;
    }

    private Endpoint resolveTargetFor(Task task) {
        String key = task.targetEndpoint();
        Endpoint ep = this.production.endpoints().resolveIfExists(key).orElseGet(() -> this.staging.endpoints().resolveIfExists(key).orElseGet(() -> {
            try {
                GradeUtils.validUri((String)"target endpoint", (String)key);
                log.warn("unresolved target endpoint, using directly {}", (Object)key);
                EndpointConfiguration epc = EndpointConfiguration.endpoint((String)key, (String)"");
                epc.writeUri(key);
                return new DefaultEndpoint(epc);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot resolve or use target endpoint " + key);
            }
        }));
        log.info("[executing '{}']: resolved target endpoint to '{}'", (Object)task.label(), (Object)ep.configuration().name());
        return ep;
    }

    public List<TaskExecution> all() {
        return new ArrayList<TaskExecution>(this.running.values());
    }

    protected boolean removeEldest(TaskExecution eldest, long size) {
        int maxSize;
        int n = maxSize = eldest.dryrun() ? 25 : 100;
        if (size > (long)maxSize) {
            return true;
        }
        Date start = eldest.startTime();
        if (start == null) {
            return false;
        }
        if (eldest.dryrun()) {
            Duration duration = Duration.between(eldest.startTime().toInstant(), Calendar.getInstance().toInstant());
            return GradeConstants.max_dryrun_execution_lifetime.minus(duration).isNegative();
        }
        return false;
    }
}

