/*
 * Decompiled with CFR 0.152.
 */
package org.grade.engine;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.NonNull;
import org.grade.common.GradeUtils;

public enum ExecutionStatus {
    submitted("submitted"),
    started("started"),
    transformed("transformed"),
    modified("modified"),
    completed("completed", true),
    failed("failed", true),
    stopped("stopped", true);

    @NonNull
    String uri;
    boolean terminal = false;

    private ExecutionStatus(String uri, boolean terminal) {
        this(uri);
        this.terminal = terminal;
    }

    @JsonValue
    public String uri() {
        return this.uri;
    }

    public boolean isFinal() {
        return this.terminal;
    }

    public static ExecutionStatus status(String uri) {
        GradeUtils.validUri((String)"invalid operation", (String)uri);
        switch (uri) {
            case "submitted": {
                return submitted;
            }
            case "started": {
                return started;
            }
            case "transformed": {
                return transformed;
            }
            case "modified": {
                return modified;
            }
            case "completed": {
                return completed;
            }
            case "failed": {
                return failed;
            }
        }
        throw new IllegalArgumentException("unknown status " + uri);
    }

    private ExecutionStatus(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.uri = uri;
    }

    static class Names {
        static final String submitted_name = "submitted";
        static final String started_name = "started";
        static final String transformed_name = "transformed";
        static final String modified_name = "modified";
        static final String completed_name = "completed";
        static final String failed_name = "failed";
        static final String stopped_name = "stopped";

        Names() {
        }
    }
}

