/*
 * Decompiled with CFR 0.152.
 */
package org.sticky.aux;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.DefaultTable;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class AdminUnits {
    public static Table buildAdminUnitsTable(Table codes, Table names) {
        List columns = codes.columns();
        for (Column col : names.columns()) {
            columns.add(col);
        }
        ArrayList<Row> nameRows = new ArrayList<Row>();
        for (Row nameRow : names) {
            HashMap data = new HashMap();
            for (Column col : names.columns()) {
                data.put(col.name(), nameRow.get(col));
            }
            Row newRow = new Row((Map)data);
            nameRows.add(newRow);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Row row : codes) {
            HashMap<QName, String> data = new HashMap<QName, String>();
            for (Column col : codes.columns()) {
                data.put(col.name(), row.get(col));
            }
            String code = row.get("code");
            for (Row nameRow : nameRows) {
                if (!nameRow.get("GAUL").equals(code)) continue;
                for (Column col : names.columns()) {
                    data.put(col.name(), nameRow.get(col.name()));
                }
            }
            Row newRow = new Row(data);
            rows.add(newRow);
        }
        DefaultTable output = new DefaultTable(columns, rows.iterator());
        return output;
    }

    public static Table enrichAdminUnitsTable(Table countries, Table flagstates) {
        HashSet<String> fsCodes = new HashSet<String>();
        for (Row row : flagstates) {
            String code = row.get("iso3code");
            if (fsCodes.contains(code)) continue;
            fsCodes.add(code);
        }
        List columns = countries.columns();
        columns.add(new Column("isFlagstate"));
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Row row : countries) {
            HashMap<QName, String> data = new HashMap<QName, String>();
            for (Column col : countries.columns()) {
                data.put(col.name(), row.get(col.name()));
            }
            String code = row.get("ISO3");
            boolean isFlagstate = false;
            if (fsCodes.contains(code)) {
                isFlagstate = true;
            }
            data.put(new QName("isFlagstate"), String.valueOf(isFlagstate));
            Row newRow = new Row(data);
            rows.add(newRow);
        }
        DefaultTable output = new DefaultTable(columns, rows.iterator());
        return output;
    }

    void $print(Source source) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(source, streamResult);
        System.out.println(stringWriter);
    }
}

