/*
 * Decompiled with CFR 0.152.
 */
package org.sticky.aux;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.fao.fi.comet.mapping.dsl.MappingDSL;
import org.fao.fi.comet.mapping.dsl.MappingDetailDSL;
import org.fao.fi.comet.mapping.dsl.MappingElementDSL;
import org.fao.fi.comet.mapping.model.Mapping;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingElement;
import org.fao.fi.comet.mapping.model.utils.jaxb.JAXB2DOMUtils;
import org.opengis.feature.Feature;
import org.sticky.Common;
import org.sticky.jaxb.Code;
import org.sticky.jaxb.Country;
import org.sticky.jaxb.Eez;
import org.virtualrepository.Asset;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.ows.Features;
import org.virtualrepository.ows.WfsFeatureType;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;
import org.w3c.dom.Element;

public class Eezs {
    public static RepositoryService vliz = Common.repository.services().lookup(new QName("vliz"));

    public static Features eezs() {
        WfsFeatureType asset = new WfsFeatureType("eez", "MarineRegions:eez", new Property[0]);
        asset.setService(vliz);
        return (Features)Common.repository.retrieve((Asset)asset, Features.class);
    }

    public static Map<String, List<String>> buildEmbeddedCodelist(Features features) {
        HashMap<String, List<String>> codelist = new HashMap<String, List<String>>();
        for (Feature f : features.all()) {
            List<String> names;
            String eezIso = f.getPropertyValue("iso_3digit").toString();
            String eezName = f.getPropertyValue("country").toString();
            if (eezIso == null) continue;
            if (!codelist.keySet().contains(eezIso)) {
                names = new ArrayList<String>();
                names.add(eezName);
                codelist.put(eezIso, names);
                continue;
            }
            names = (List)codelist.get(eezIso);
            if (names.contains(eezName)) continue;
            names.add(eezName);
            codelist.put(eezIso, names);
        }
        return codelist;
    }

    public static MappingData buildMappingSovereignty(Features features, Map<String, List<String>> codelist) {
        MappingData mappingData = new MappingData();
        mappingData.setDescription("This mapping provides a 1-N relationship between a ISO3 code entity (identifying a country) and one or more MarineRegions id (identifying an Exclusive Economic Zone - EEZ), giving the sovereignty of country over EEZs. The mapping is entirely constructed from the VLIZ Marine Regions MarBound database.");
        mappingData.setVersion("1.0");
        mappingData.setProducedOn(new Date());
        mappingData.setProducedBy("Emmanuel Blondel");
        for (String srcCode : codelist.keySet()) {
            String message = null;
            if (srcCode.length() < 3) {
                message = srcCode + " is not an ISO3 code." + " Action required at source level";
            } else if (srcCode.length() > 3 || srcCode.contains("-")) {
                message = srcCode + " is not an ISO3 code." + " Composite EEZ detected. Action required at source level";
            }
            if (message != null) continue;
            Predicate<Feature> codePredicate = p -> p.getPropertyValue("iso_3digit").toString().equals(srcCode);
            Predicate<Feature> namesPredicate = p -> ((List)codelist.get(srcCode)).contains(p.getPropertyValue("sovereign").toString());
            Predicate<Feature> fullPredicate = codePredicate.or(namesPredicate);
            List filteredFeatures = features.all().stream().filter(fullPredicate).collect(Collectors.toList());
            HashMap<Integer, String> trgCodes = new HashMap<Integer, String>();
            if (filteredFeatures.size() > 0) {
                for (Feature f : filteredFeatures) {
                    String sovName = f.getPropertyValue("sovereign").toString();
                    if (!codelist.get(srcCode).contains(sovName)) continue;
                    String mrgid = f.getPropertyValue("mrgid").toString();
                    Integer mrgidValue = Double.valueOf(mrgid).intValue();
                    if (trgCodes.containsKey(mrgid)) continue;
                    String label = f.getPropertyValue("eez").toString();
                    trgCodes.put(mrgidValue, label);
                }
            }
            MappingElement source = MappingElementDSL.wrap((Element)JAXB2DOMUtils.asElement((Object)Country.coding(new Code(srcCode, "iso3", null))));
            Mapping mappingEntry = MappingDSL.map((MappingElement)source);
            for (Integer trgCode : trgCodes.keySet()) {
                String trgCodeLabel = (String)trgCodes.get(trgCode);
                mappingEntry.to(MappingDetailDSL.target((MappingElement)MappingElementDSL.wrap((Element)JAXB2DOMUtils.asElement((Object)Eez.coding(new Code(trgCode.toString(), "mrgid", trgCodeLabel))))));
            }
            mappingData.include(new Mapping[]{mappingEntry});
        }
        return mappingData;
    }

    public static MappingData buildMappingExploitation(Features features, Map<String, List<String>> codelist, Table adminUnits) {
        MappingData mappingData = new MappingData();
        mappingData.setDescription("This mapping provides a 1-N relationship between a ISO3 code entity (identifying a flagstate) and one or more MarineRegions id (identifying an Exclusive Economic Zone - EEZ), giving the exploitation rights of flagstate over EEZs. is constructed from the VLIZ MarineRegions EEZ - MarBound database and from the information if a country is a flagstate");
        mappingData.setVersion("1.0");
        mappingData.setProducedOn(new Date());
        mappingData.setProducedBy("Emmanuel Blondel");
        HashMap<String, Boolean> refadmin = new HashMap<String, Boolean>();
        for (Row row : adminUnits) {
            String code = row.get("ISO3");
            Boolean isFlagstate = Boolean.valueOf(row.get("isFlagstate"));
            if (refadmin.keySet().contains(code)) continue;
            refadmin.put(code, isFlagstate);
        }
        for (String srcCode : codelist.keySet()) {
            String message = null;
            if (srcCode.length() < 3) {
                message = srcCode + " is not an ISO3 code." + " Action required at source level";
            } else if (srcCode.length() > 3 || srcCode.contains("-")) {
                message = srcCode + " is not an ISO3 code." + " Composite EEZ detected. Action required at source level";
            }
            if (message != null) continue;
            Boolean isFlagstate = (Boolean)refadmin.get(srcCode);
            if (isFlagstate == null) {
                isFlagstate = false;
            }
            Predicate<Feature> codePredicate = p -> p.getPropertyValue("iso_3digit").toString().equals(srcCode);
            Predicate<Feature> namesPredicate = p -> ((List)codelist.get(srcCode)).contains(p.getPropertyValue("sovereign").toString());
            Predicate<Feature> fullPredicate = codePredicate.or(namesPredicate);
            List filteredFeatures = features.all().stream().filter(fullPredicate).collect(Collectors.toList());
            HashMap<Integer, String> trgCodes = new HashMap<Integer, String>();
            if (filteredFeatures.size() > 0) {
                for (Feature f : filteredFeatures) {
                    String eezCode = f.getPropertyValue("iso_3digit").toString();
                    if (eezCode == null) continue;
                    if (eezCode.equals(srcCode)) {
                        if (!isFlagstate.booleanValue()) continue;
                        String mrgid = f.getPropertyValue("mrgid").toString();
                        Integer mrgidValue = Double.valueOf(mrgid).intValue();
                        if (trgCodes.containsKey(mrgid)) continue;
                        String label = f.getPropertyValue("eez").toString();
                        trgCodes.put(mrgidValue, label);
                        continue;
                    }
                    String sovName = f.getPropertyValue("sovereign").toString();
                    if (!codelist.get(srcCode).contains(sovName)) continue;
                    String mrgid = f.getPropertyValue("mrgid").toString();
                    Integer mrgidValue = Double.valueOf(mrgid).intValue();
                    if (trgCodes.containsKey(mrgid)) continue;
                    String label = f.getPropertyValue("eez").toString();
                    trgCodes.put(mrgidValue, label);
                }
            }
            MappingElement source = MappingElementDSL.wrap((Element)JAXB2DOMUtils.asElement((Object)Country.coding(new Code(srcCode, "iso3", null))));
            Mapping mappingEntry = MappingDSL.map((MappingElement)source);
            for (Integer trgCode : trgCodes.keySet()) {
                String trgCodeLabel = (String)trgCodes.get(trgCode);
                mappingEntry.to(MappingDetailDSL.target((MappingElement)MappingElementDSL.wrap((Element)JAXB2DOMUtils.asElement((Object)Eez.coding(new Code(trgCode.toString(), "mrgid", trgCodeLabel))))));
            }
            mappingData.include(new Mapping[]{mappingEntry});
        }
        return mappingData;
    }
}

