/*
 * Decompiled with CFR 0.152.
 */
package org.sticky.aux;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.fao.fi.comet.mapping.model.Mapping;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingDetail;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.DefaultTable;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Worms {
    public static Table buildWormsTaxonomicHierarchy(MappingData mappingData, Table datasetToFilter) {
        ArrayList<Row> trgRows = new ArrayList<Row>();
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("species"));
        columns.add(new Column("genus"));
        columns.add(new Column("family"));
        columns.add(new Column("order"));
        columns.add(new Column("class"));
        columns.add(new Column("phylum"));
        columns.add(new Column("kingdom"));
        List<Row> nameRows = Worms.toRowsList(datasetToFilter);
        Collection mappings = mappingData.getMappings();
        int total = mappings.size();
        int count = 1;
        for (Mapping mapping : mappings) {
            List details = (List)mapping.getTargets();
            MappingDetail target = (MappingDetail)details.get(0);
            String aphiaId = target.getTargetElement().getId().getElementId().toString().split("urn:")[1];
            Row srcRow = (Row)nameRows.stream().filter(p -> p.get("id").equals(aphiaId)).collect(Collectors.toList()).get(0);
            HashMap<QName, String> data = new HashMap<QName, String>();
            for (Column col : columns) {
                if (col.name().getLocalPart().equals("species")) {
                    data.put(col.name(), aphiaId);
                    continue;
                }
                String content = srcRow.get(col.name().getLocalPart());
                if (content.equals("")) continue;
                Row refRow = (Row)nameRows.stream().filter(p -> p.get("scientific_name").equals(content)).collect(Collectors.toList()).get(0);
                String otherAphiaId = refRow.get("id");
                data.put(col.name(), otherAphiaId);
            }
            Row trgRow = new Row(data);
            trgRows.add(trgRow);
            System.out.println(count + " / " + total);
            ++count;
        }
        DefaultTable output = new DefaultTable(columns, trgRows.iterator());
        return output;
    }

    public static Table buildWormsSubset(Table hierarchicalDataset, Table nameDataset) {
        ArrayList<Row> trgRows = new ArrayList<Row>();
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("aphiaId"));
        columns.add(new Column("name"));
        columns.add(new Column("rank"));
        columns.add(new Column("author"));
        List srcColumns = hierarchicalDataset.columns();
        List<Row> nameRows = Worms.toRowsList(nameDataset);
        for (Row codeRow : hierarchicalDataset) {
            for (Column col : srcColumns) {
                boolean yetRetrieved;
                String aphiaId = codeRow.get(col);
                if (aphiaId.equals("") || aphiaId.equals("null") || (yetRetrieved = trgRows.stream().filter(p -> p.get("aphiaId").equals(aphiaId)).collect(Collectors.toList()).size() > 0)) continue;
                Row nameRow = (Row)nameRows.stream().filter(p -> p.get("id").equals(aphiaId)).collect(Collectors.toList()).get(0);
                HashMap<QName, String> data = new HashMap<QName, String>();
                data.put(((Column)columns.get(0)).name(), aphiaId);
                data.put(((Column)columns.get(1)).name(), nameRow.get("scientific_name"));
                data.put(((Column)columns.get(2)).name(), col.name().getLocalPart());
                data.put(((Column)columns.get(3)).name(), nameRow.get("author"));
                Row trgRow = new Row(data);
                trgRows.add(trgRow);
            }
        }
        DefaultTable output = new DefaultTable(columns, trgRows.iterator());
        return output;
    }

    public static List<Row> toRowsList(Table table) {
        ArrayList<Row> nameRows = new ArrayList<Row>();
        for (Row nameRow : table) {
            HashMap<QName, String> data = new HashMap<QName, String>();
            for (Column col : table.columns()) {
                data.put(col.name(), nameRow.get(col));
            }
            Row newRow = new Row(data);
            nameRows.add(newRow);
        }
        return nameRows;
    }
}

