/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io.aux;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.grade.common.GradeUtils;
import org.grade.io.aux.Csv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
implements Iterable<Map<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(Table.class);
    private List<String> columns = new ArrayList<String>();
    private CSVReader reader;

    Table(Csv csv, InputStream stream) {
        this.reader = new CSVReader((Reader)new InputStreamReader(stream, csv.encoding()), csv.delimiter(), csv.quote());
        for (String name : this.reader.readNext()) {
            this.columns.add(this.urisafe(name));
        }
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        return new RowIterator();
    }

    private String urisafe(String s) {
        return s.replaceAll("\t+", "_").replaceAll("\n+", "_").replaceAll("\\s+", "_").replaceAll("\\+", "_").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
    }

    class RowIterator
    implements Iterator<Map<String, String>> {
        private final Map<String, String> data = new HashMap<String, String>();
        private String[] row;
        private Throwable error;

        RowIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.row != null) {
                return true;
            }
            try {
                this.row = Table.this.reader.readNext();
            }
            catch (IOException e) {
                this.error = e;
            }
            return this.row != null;
        }

        @Override
        public Map<String, String> next() {
            try {
                this.checkRow();
            }
            catch (RuntimeException e) {
                this.close();
            }
            Map<String, String> result = this.buildRow();
            this.row = null;
            return result;
        }

        private void checkRow() {
            if (this.error != null) {
                throw GradeUtils.unchecked((Throwable)this.error);
            }
            if (this.row == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
        }

        private Map<String, String> buildRow() {
            this.data.clear();
            for (int i = 0; i < Table.this.columns.size() && this.row.length > i; ++i) {
                this.data.put((String)Table.this.columns.get(i), this.row[i]);
            }
            return this.data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void close() {
            try {
                Table.this.reader.close();
            }
            catch (Exception e) {
                log.warn("could not close CSV stream", (Throwable)e);
            }
        }
    }
}

