/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io.transforms;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.grade.io.aux.Table;
import org.grade.io.transforms.RawTransform;
import org.grade.io.transforms.TransformUtils;

@ApplicationScoped
public class TableTransform
implements RawTransform<Table> {
    private static final String tableresource = TransformUtils.mintFor("table");

    @Override
    public Class<Table> type() {
        return Table.class;
    }

    @Override
    public Model triplify(Table table) throws Exception {
        Model model = ModelFactory.createDefaultModel();
        for (Map<String, String> row : table) {
            String rowresource = TransformUtils.mintA("row");
            TransformUtils.emit(model, tableresource, "row", rowresource);
            row.entrySet().forEach($ -> TransformUtils.emitLiteral(model, rowresource, (String)$.getKey(), (String)$.getValue()));
        }
        return model;
    }

    public String toString() {
        return "Table->Raw";
    }
}

