/*
 * Decompiled with CFR 0.152.
 */
package grade.test;

import com.googlecode.jeeunit.JeeunitRunner;
import java.io.File;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.grade.common.ApplicationLifecycle;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.Configuration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JeeunitRunner.class)
public class CdiTest {
    private static File __config_location = new File("target");
    @Inject
    ApplicationLifecycle app;
    @Inject
    @Qualifiers.New
    Instance<Configuration> configs;
    @Rule
    public TestName __name = new TestName();
    Logger log;

    @BeforeClass
    public static void __setup() throws Exception {
        System.setProperty("grade.config", __config_location.getAbsolutePath());
    }

    @Before
    public void __before() {
        this.log = LoggerFactory.getLogger((String)(this.getClass().getSimpleName() + ":" + this.__name.getMethodName()));
        this.log.info("------start test: {} ----------------------------------------------------------------------------------\n", (Object)this.__name.getMethodName());
        this.app.start();
    }

    @After
    public void __after() {
        this.app.stop();
        File file = new File(__config_location, "grade.json");
        if (file.exists()) {
            if (!file.delete()) {
                this.log.warn("failed removing test configuration @ {}, {}", (Object)file.getAbsolutePath(), (Object)"tests may not be isolated".toUpperCase());
            } else {
                this.log.info("removed test configuration @ {}", (Object)file.getAbsolutePath());
            }
        }
        this.log.info("------end test: {} ----------------------------------------------------------------------------------\n", (Object)this.__name.getMethodName());
    }

    protected Configuration freshConfig() {
        return (Configuration)this.configs.get();
    }

    @AfterClass
    public static void __shutdown() {
        System.clearProperty("grade.config");
    }
}

