/*
 * Decompiled with CFR 0.152.
 */
package org.grade.test;

import java.io.File;
import java.util.UUID;
import java.util.function.Consumer;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.grade.test.EmbeddedGrade;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedTest {
    private static File __config_location = new File("target");
    protected static EmbeddedGrade grade;
    @Rule
    public TestName __name = new TestName();
    Logger log;

    @BeforeClass
    public static void __setup() throws Exception {
        System.setProperty("grade.config", __config_location.getAbsolutePath());
        grade = new EmbeddedGrade();
    }

    @Before
    public void __before() {
        this.log = LoggerFactory.getLogger((String)(this.getClass().getSimpleName() + ":" + this.__name.getMethodName()));
        this.log.info("------start test: {} ----------------------------------------------------------------------------------\n", (Object)this.__name.getMethodName());
    }

    protected <T> Entity<T> bodyWith(T o) {
        return Entity.entity(o, (String)"application/json");
    }

    protected Variant media(MediaType mediatype) {
        return new Variant(mediatype, (String)null, (String)null);
    }

    protected <T> Entity<T> bodyWith(T o, Variant v) {
        return Entity.entity(o, (Variant)v);
    }

    protected Variant compressed(MediaType type) {
        return new Variant(type, (String)null, "gzip");
    }

    protected <T> Entity<T> xmlBodyWith(T o) {
        return Entity.entity(o, (String)"application/xml");
    }

    protected <T> TestClause<T> over(final T ... things) {
        return new TestClause<T>(){

            @Override
            public void repeat(Consumer<T> test) {
                for (Object thing : things) {
                    test.accept(thing);
                }
            }
        };
    }

    protected Response.Status.Family typeof(Response response) {
        return response.getStatusInfo().getFamily();
    }

    protected String mediatypeof(Response response) {
        return response.getHeaderString("Content-Type");
    }

    protected String someName() {
        return UUID.randomUUID().toString();
    }

    @After
    public void __after() {
        File file = new File(__config_location, "grade.json");
        if (file.exists()) {
            if (!file.delete()) {
                this.log.warn("failed removing test configuration @ {}, {}", (Object)file.getAbsolutePath(), (Object)"tests may not be isolated".toUpperCase());
            } else {
                this.log.info("removed test configuration @ {}", (Object)file.getAbsolutePath());
            }
        }
        this.log.info("------end test: {} ----------------------------------------------------------------------------------\n", (Object)this.__name.getMethodName());
    }

    @AfterClass
    public static void __shutdown() {
        System.clearProperty("grade.config");
    }

    protected static interface TestClause<T> {
        public void repeat(Consumer<T> var1);
    }
}

