/*
 * Decompiled with CFR 0.152.
 */
package org.grade.client.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.grade.client.upload.Deployment;
import org.grade.client.upload.UploadType;
import org.grade.client.upload.csv.CsvParams;
import org.grade.client.upload.dsl.Dsl;

public class Grade {
    public static UploadType xml = new UploadType.Default("xml", MediaType.APPLICATION_XML_TYPE);
    public static UploadType json = new UploadType.Default("json", MediaType.APPLICATION_JSON_TYPE);
    @NonNull
    private Deployment deployment;
    @NonNull
    private UploadType.Private info;
    @NonNull
    private InputStream content;
    private static ClientBuilder maker = (ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MultiPartFeature.class)).register(GZipEncoder.class)).register((Object)new LoggingFilter(Logger.getLogger(LoggingFilter.class.getName()), true));
    private static String api_template = "service/stage/endpoint/%s/dropin/%s/%s";

    public static CsvParams csvparams() {
        return new CsvParams();
    }

    public static Dsl.TypeClause drop(@NonNull String file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        return Grade.drop(new FileInputStream(new File(file)));
    }

    public static Dsl.TypeClause drop(InputStream c) {
        Grade $ = new Grade();
        $.content(c);
        return type -> {
            if (!(type instanceof UploadType.Private)) {
                throw new IllegalArgumentException("not an expected upload type");
            }
            $.info((UploadType.Private)type);
            return dpl -> {
                $.deployment(dpl);
                return $::in;
            };
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void in(@NonNull String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        InputStream closeable = this.content;
        try {
            String path = String.format(api_template, this.deployment.endpoint(), this.info.path(), label);
            Response response = maker.build().target(this.deployment.uri()).path(path).request().post(this.info.bodyWith(closeable));
            if (!response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                throw new WebApplicationException(response);
            }
        }
        finally {
            if (Collections.singletonList(closeable).get(0) != null) {
                closeable.close();
            }
        }
    }

    private Grade deployment(@NonNull Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("deployment is null");
        }
        this.deployment = deployment;
        return this;
    }

    private Grade info(@NonNull UploadType.Private info) {
        if (info == null) {
            throw new IllegalArgumentException("info is null");
        }
        this.info = info;
        return this;
    }

    private Grade content(@NonNull InputStream content) {
        if (content == null) {
            throw new IllegalArgumentException("content is null");
        }
        this.content = content;
        return this;
    }
}

