/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.grade.configuration;

import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.grade.GradeProxy;
import org.virtual.grade.common.CommonProducers;
import org.virtual.grade.common.Utils;
import org.virtual.grade.configuration.Configuration;
import org.virtual.grade.configuration.ConfigurationContext;
import org.virtual.grade.configuration.ConfigurationLocator;
import org.virtual.grade.configuration.ServiceConfiguration;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.spi.ServiceProxy;

@Module(includes={CommonProducers.class}, library=true)
public class ConfigurationProducers {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationProducers.class);

    @Provides
    @Singleton
    List<RepositoryService> services(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        ArrayList<RepositoryService> services = new ArrayList<RepositoryService>();
        for (ServiceConfiguration $ : configuration.services()) {
            try {
                $.validate();
                GradeProxy proxy = new GradeProxy($);
                services.add(new RepositoryService($.name(), (ServiceProxy)proxy, this.propertiesOf($).toArray(new Property[0])));
            }
            catch (Exception e) {
                log.error("invalid configuration for service " + $.name() + ": ignoring it (see cause)", (Throwable)e);
            }
        }
        return services;
    }

    @Provides
    @Singleton
    Configuration configuration(ConfigurationLocator locator, ConfigurationContext ctx) {
        Logger log = LoggerFactory.getLogger(ConfigurationLocator.class);
        File location = locator.locate();
        String path = location.getAbsolutePath();
        InputStream stream = null;
        try {
            if (Utils.isValid(location)) {
                log.info("loading configuration @ {}", (Object)path);
                stream = new FileInputStream(location);
            } else {
                stream = ConfigurationLocator.class.getResourceAsStream("/grade-repositories.json");
                if (stream == null) {
                    throw new AssertionError((Object)"no configuration found on file system or classpath");
                }
                log.info("starting with classpath configuration, persisting @ {}", (Object)path);
            }
            return ctx.bind(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read the configuration @ " + path, e);
        }
    }

    private List<Property> propertiesOf(ServiceConfiguration configuration) {
        return configuration.properties().entrySet().stream().map($ -> new Property((String)$.getKey(), $.getValue())).collect(Collectors.toList());
    }
}

