/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicvalues;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Externals {

    public static class MapAdapter
    extends XmlAdapter<Entries, Map<Object, Object>> {
        public Map<Object, Object> unmarshal(Entries entries) throws Exception {
            HashMap<Object, Object> in = new HashMap<Object, Object>();
            for (Entry e : entries.value) {
                in.put(e.key, e.value);
            }
            return in;
        }

        public Entries marshal(Map<Object, Object> map) throws Exception {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (Map.Entry<Object, Object> e : map.entrySet()) {
                entries.add(new Entry(e.getKey(), e.getValue()));
            }
            Entries out = new Entries();
            out.value = entries;
            return out;
        }
    }

    static class Entry {
        @XmlElement
        Object key;
        @XmlElement
        Object value;

        public Entry() {
        }

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    @XmlType
    static class Entries {
        @XmlElement(name="entry")
        List<Entry> value;

        Entries() {
        }
    }

    @XmlRootElement(name="list")
    public static class ValueList
    implements Iterable<Object> {
        @XmlElementWrapper(name="list")
        @XmlElement(name="element")
        public List<Object> elements;

        ValueList() {
            this.elements = new ArrayList<Object>();
        }

        public ValueList(List<Object> elements) {
            this.elements = elements;
        }

        public String toString() {
            return this.elements.toString();
        }

        @Override
        public Iterator<Object> iterator() {
            return this.elements.iterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueList other = (ValueList)obj;
            return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
        }
    }

    @XmlRootElement(name="map")
    public static class ValueMap {
        @XmlJavaTypeAdapter(value=MapAdapter.class)
        @XmlElement(name="entries")
        public Map<Object, Object> elements;

        ValueMap() {
            this.elements = new LinkedHashMap<Object, Object>();
        }

        public ValueMap(Map<Object, Object> elements) {
            this.elements = elements;
        }

        public String toString() {
            return this.elements.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueMap other = (ValueMap)obj;
            return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
        }
    }
}

