/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicvalues;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dynamicvalues.Directives;
import org.dynamicvalues.Dynamic;
import org.dynamicvalues.Exclusion;
import org.dynamicvalues.Externals;
import org.dynamicvalues.Mapping;

enum Type {
    valuemap{

        @Override
        Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            state.put(System.identityHashCode(o), map);
            for (Map.Entry<Object, Object> el : ((Externals.ValueMap)Externals.ValueMap.class.cast((Object)o)).elements.entrySet()) {
                map.put(el.getKey(), Dynamic.valueOf(el.getValue(), state, directives));
            }
            return map;
        }
    }
    ,
    valuelist{

        @Override
        Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            state.put(System.identityHashCode(o), list);
            for (Object el : ((Externals.ValueList)Externals.ValueList.class.cast((Object)o)).elements) {
                list.add(Dynamic.valueOf(el, state, directives));
            }
            return list;
        }
    }
    ,
    voidtype,
    atomic,
    collection{

        @Override
        Object toExternal(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            value = new Externals.ValueList(list);
            state.put(System.identityHashCode(o), value);
            for (Object element : (Iterable)Iterable.class.cast(o)) {
                list.add(Dynamic.externalValueOf(element, state, directives));
            }
            return value;
        }

        @Override
        Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            state.put(System.identityHashCode(o), list);
            for (Object element : (Iterable)Iterable.class.cast(o)) {
                list.add(Dynamic.valueOf(element, state, directives));
            }
            return list;
        }
    }
    ,
    array{

        @Override
        Object toExternal(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            value = new Externals.ValueList(list);
            state.put(System.identityHashCode(o), value);
            for (int i = 0; i < Array.getLength(o); ++i) {
                list.add(Dynamic.externalValueOf(Array.get(o, i), state, directives));
            }
            return value;
        }

        @Override
        Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            state.put(System.identityHashCode(o), list);
            for (int i = 0; i < Array.getLength(o); ++i) {
                list.add(Dynamic.valueOf(Array.get(o, i), state, directives));
            }
            return list;
        }
    }
    ,
    map{

        @Override
        Object toExternal(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            value = new Externals.ValueMap(map);
            state.put(System.identityHashCode(o), value);
            for (Map.Entry e : ((Map)o).entrySet()) {
                map.put(Dynamic.externalValueOf(e.getKey(), state, directives), Dynamic.externalValueOf(e.getValue(), state, directives));
            }
            return value;
        }

        @Override
        Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            state.put(System.identityHashCode(o), map);
            for (Map.Entry e : ((Map)o).entrySet()) {
                map.put(Dynamic.valueOf(e.getKey(), state, directives), Dynamic.valueOf(e.getValue(), state, directives));
            }
            return map;
        }
    }
    ,
    object{

        @Override
        Object toExternal(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Externals.ValueMap vmap = new Externals.ValueMap(map);
            state.put(System.identityHashCode(o), vmap);
            for (Map.Entry<String, Object> field : this.gatherFields(o, state, directives).entrySet()) {
                Object fieldValue;
                if (field.getKey().startsWith("this$") || (fieldValue = Dynamic.externalValueOf(field.getValue(), state, directives)) == null || this.empty(fieldValue)) continue;
                map.put(field.getKey(), fieldValue);
            }
            vmap.elements = this.withoutEmpties(vmap.elements);
            return vmap;
        }

        @Override
        Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            Object value = state.get(System.identityHashCode(o));
            if (value != null) {
                return value;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            state.put(System.identityHashCode(o), map);
            for (Map.Entry<String, Object> field : this.gatherFields(o, state, directives).entrySet()) {
                if (field.getKey().startsWith("this$")) continue;
                try {
                    Object fieldValue = Dynamic.valueOf(field.getValue(), state, directives);
                    if (fieldValue == null) continue;
                    map.put(field.getKey(), fieldValue);
                }
                catch (Exception e) {
                    throw new Exception("cannot turn field " + field.getKey() + " with value " + field.getValue() + " into a dynamic value", e);
                }
            }
            return this.withoutEmpties(map);
        }

        private Map<Object, Object> withoutEmpties(Map<Object, Object> map) {
            Iterator<Object> it = map.values().iterator();
            while (it.hasNext()) {
                if (!this.empty(it.next())) continue;
                it.remove();
            }
            return map;
        }

        private boolean empty(Object object) {
            System.out.println(object.getClass());
            if (object instanceof Map) {
                return ((Map)Map.class.cast(object)).isEmpty();
            }
            if (object instanceof Collection) {
                return ((Collection)Collection.class.cast(object)).isEmpty();
            }
            return false;
        }

        private Map<String, Object> gatherFields(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            Class<?> clazz = o.getClass();
            List<Field> fields = this.valueFieldsOf(o, clazz, directives);
            for (Field field : fields) {
                Object fieldValue = field.get(o);
                if (fieldValue == null) continue;
                for (Mapping mapping : directives.mappings()) {
                    Object adapted = mapping.map(o, field, fieldValue);
                    if (adapted == null) continue;
                    fieldValue = adapted;
                    break;
                }
                values.put(field.getName(), fieldValue);
            }
            return values;
        }

        private List<Field> valueFieldsOf(Object o, Class<?> clazz, Directives directives) throws Exception {
            ArrayList<Field> fields = new ArrayList<Field>();
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                fields.addAll(this.valueFieldsOf(o, superclass, directives));
            }
            block0: for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                for (Exclusion directive : directives.excludes()) {
                    if (!directive.exclude(o, field)) continue;
                    continue block0;
                }
                fields.add(field);
            }
            return fields;
        }
    };

    private static final List<Class<?>> atomics;

    Object toExternal(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
        return o;
    }

    Object toDynamic(Object o, Map<Integer, Object> state, Directives directives) throws Exception {
        return o;
    }

    public static Type of(Object o) {
        if (o == null) {
            return voidtype;
        }
        if (o instanceof Externals.ValueMap) {
            return valuemap;
        }
        if (o instanceof Externals.ValueList) {
            return valuelist;
        }
        if (atomics.contains(o.getClass())) {
            return atomic;
        }
        if (o.getClass().isArray()) {
            return array;
        }
        if (o instanceof Iterable) {
            return collection;
        }
        if (o instanceof Map) {
            return map;
        }
        return object;
    }

    static {
        atomics = Arrays.asList(String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class);
    }
}

