/*
 * Decompiled with CFR 0.152.
 */
package api.tabular;

import api.tabular.Column;
import api.tabular.Row;
import api.tabular.impl.SimpleTable;
import api.tabular.impl.StreamedTable;
import api.tabular.utils.Streamable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;

public interface Table
extends Streamable<Row> {
    public List<Column> columns();

    public SimpleTable materialise();

    public boolean materialised();

    default public Table with(final UnaryOperator<Row> transform) {
        final Iterator current = this.iterator();
        return new StreamedTable(new ArrayList<Column>(this.columns()), new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return current.hasNext();
            }

            @Override
            public Row next() {
                return (Row)transform.apply(current.next());
            }
        });
    }

    default public Table copy() {
        return this.with(Row::new);
    }
}

