/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import lombok.NonNull;
import org.virtual.files.local.LocalConfiguration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LocalConfiguration.class, name="local")})
public abstract class ServiceConfiguration {
    @JsonProperty
    @NonNull
    private QName name;
    @JsonProperty
    @NonNull
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonProperty
    private boolean overwrite = true;

    public ServiceConfiguration add(String name, String val) {
        this.properties.put(name, val);
        return this;
    }

    public abstract String type();

    public abstract void validate();

    @NonNull
    public QName name() {
        return this.name;
    }

    @NonNull
    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public ServiceConfiguration name(@NonNull QName name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public ServiceConfiguration properties(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        this.properties = properties;
        return this;
    }

    public ServiceConfiguration overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QName this$name = this.name();
        QName other$name = other.name();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Map<String, String> this$properties = this.properties();
        Map<String, String> other$properties = other.properties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        return this.overwrite() == other.overwrite();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QName $name = this.name();
        result = result * 59 + ($name == null ? 0 : ((Object)$name).hashCode());
        Map<String, String> $properties = this.properties();
        result = result * 59 + ($properties == null ? 0 : ((Object)$properties).hashCode());
        result = result * 59 + (this.overwrite() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ServiceConfiguration(name=" + this.name() + ", properties=" + this.properties() + ", overwrite=" + this.overwrite() + ")";
    }
}

