/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.workspace;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.workspace.CurrentUser;
import org.virtual.workspace.StreamImporter;
import org.virtual.workspace.StreamPublisher;
import org.virtual.workspace.WorkspaceBrowser;
import org.virtual.workspace.types.WorkspaceType;
import org.virtual.workspace.types.WorkspaceTypes;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.ImportAdapter;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Lifecycle;
import org.virtualrepository.spi.PublishAdapter;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;
import org.virtualrepository.spi.Transform;

@Singleton
public class WorkspaceProxy
implements ServiceProxy,
Lifecycle {
    private static Logger log = LoggerFactory.getLogger(WorkspaceProxy.class);
    @Inject
    WorkspaceBrowser browser;
    @Inject
    Provider<Workspace> ws;
    @Inject
    Provider<CurrentUser> currentUser;
    @Inject
    WorkspaceTypes types;
    private final List<Publisher<?, ?>> publishers = new ArrayList();
    private final List<Importer<?, ?>> importers = new ArrayList();

    public void init() throws Exception {
        log.info("supported types {}", (Object)this.types);
        for (WorkspaceType type : this.types) {
            this.addAccessorsFor(type);
        }
    }

    private void addAccessorsFor(WorkspaceType type) {
        Transform<?, ?, InputStream> toStream;
        StreamImporter importer = new StreamImporter(this.ws, type);
        StreamPublisher publisher = new StreamPublisher(this.ws, type);
        this.importers.add(importer);
        this.publishers.add(publisher);
        Transform<?, InputStream, ?> fromStream = type.fromStream();
        if (fromStream != null) {
            this.importers.add(ImportAdapter.adapt((Importer)importer, fromStream));
        }
        if ((toStream = type.toStream()) != null) {
            this.publishers.add(PublishAdapter.adapt((Publisher)publisher, toStream));
        }
    }

    public Browser browser() {
        return this.browser;
    }

    public List<? extends Importer<?, ?>> importers() {
        return this.importers;
    }

    public List<? extends Publisher<?, ?>> publishers() {
        return this.publishers;
    }
}

