/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.workspace.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.virtual.workspace.types.WorkspaceType;
import org.virtualrepository.AssetType;

@Singleton
public class WorkspaceTypes
implements Iterable<WorkspaceType> {
    private final Map<AssetType, WorkspaceType> mapping = new HashMap<AssetType, WorkspaceType>();

    @Inject
    public WorkspaceTypes(Set<WorkspaceType> types) {
        for (WorkspaceType type : types) {
            this.mapping.put((AssetType)type.assetType(), type);
        }
    }

    public WorkspaceType thatCorrespondTo(AssetType type) {
        return this.mapping.get(type);
    }

    public Collection<WorkspaceType> thatCorrespondTo(Collection<? extends AssetType> assetTypes) {
        HashSet<WorkspaceType> types = new HashSet<WorkspaceType>();
        for (AssetType assetType : assetTypes) {
            if (!this.mapping.containsKey(assetType)) continue;
            types.add(this.mapping.get(assetType));
        }
        return types;
    }

    @Override
    public Iterator<WorkspaceType> iterator() {
        return this.mapping.values().iterator();
    }

    public String toString() {
        return this.mapping.values().toString();
    }
}

