/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows.profile;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.sis.xml.MarshallerPool;
import org.geotoolkit.wfs.xml.WFSMarshallerPool;
import org.geotoolkit.wfs.xml.v100.FeatureTypeType;
import org.geotoolkit.wfs.xml.v100.WFSCapabilitiesType;
import org.virtual.ows.WfsClient;
import org.virtual.ows.common.Utils;
import org.virtual.ows.profile.Wfs100TypeProfile;
import org.virtual.ows.profile.WfsBaseProfile;
import org.virtual.ows.profile.WfsTypeProfile;
import org.virtualrepository.Properties;
import org.virtualrepository.Property;

public class Wfs100Profile
extends WfsBaseProfile {
    WFSCapabilitiesType capabilities;

    public Wfs100Profile(WfsClient client) {
        super(client);
    }

    @Override
    public void $update(Properties properties) {
        if (this.capabilities != null) {
            properties.add(new Property[]{new Property("title", (Object)this.capabilities.getService().getTitle()), new Property("abstract", (Object)this.capabilities.getService().getAbstract()), new Property("keywords", (Object)this.capabilities.getService().getKeywords()), new Property("type", (Object)this.capabilities.getService().getName()), new Property("version", (Object)this.capabilities.getVersion())});
        }
    }

    @Override
    public List<WfsTypeProfile> types() {
        ArrayList<WfsTypeProfile> profiles = new ArrayList<WfsTypeProfile>();
        if (this.capabilities != null) {
            for (FeatureTypeType type : this.capabilities.getFeatureTypeList().getFeatureType()) {
                profiles.add(new Wfs100TypeProfile(type));
            }
        }
        return profiles;
    }

    @Override
    public void $refresh() {
        InputStream stream = (InputStream)this.client.capabilities().get(InputStream.class);
        try {
            MarshallerPool pool = WFSMarshallerPool.getInstanceV100();
            Unmarshaller unmarshaller = pool.acquireUnmarshaller();
            Object obj = unmarshaller.unmarshal(stream);
            if (obj instanceof JAXBElement) {
                obj = ((JAXBElement)obj).getValue();
                this.capabilities = (WFSCapabilitiesType)obj;
            }
        }
        catch (Exception e) {
            Utils.unchecked("cannot read OGC WFS GetCapabilities document", e);
        }
    }
}

