/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows.profile;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.sis.xml.MarshallerPool;
import org.geotoolkit.wfs.xml.WFSMarshallerPool;
import org.geotoolkit.wfs.xml.v200.FeatureTypeType;
import org.geotoolkit.wfs.xml.v200.WFSCapabilitiesType;
import org.virtual.ows.WfsClient;
import org.virtual.ows.common.Utils;
import org.virtual.ows.profile.Wfs200TypeProfile;
import org.virtual.ows.profile.WfsBaseProfile;
import org.virtual.ows.profile.WfsTypeProfile;
import org.virtualrepository.Properties;
import org.virtualrepository.Property;

public class Wfs200Profile
extends WfsBaseProfile {
    WFSCapabilitiesType capabilities;

    public Wfs200Profile(WfsClient client) {
        super(client);
    }

    @Override
    public void $update(Properties properties) {
        if (this.capabilities != null) {
            properties.add(new Property[]{new Property("title", (Object)this.capabilities.getServiceIdentification().getFirstTitle()), new Property("abstract", (Object)this.capabilities.getServiceIdentification().getFirstAbstract()), new Property("keywords", (Object)this.capabilities.getServiceIdentification().getKeywords().stream().flatMap($ -> $.getKeywordList().stream()).collect(Collectors.toList()).toString()), new Property("type", (Object)this.capabilities.getServiceIdentification().getServiceType().getValue()), new Property("version", (Object)this.capabilities.getVersion()), new Property("provider", (Object)this.capabilities.getServiceProvider().getProviderName())});
        }
    }

    @Override
    public List<WfsTypeProfile> types() {
        ArrayList<WfsTypeProfile> profiles = new ArrayList<WfsTypeProfile>();
        if (this.capabilities != null) {
            for (FeatureTypeType type : this.capabilities.getFeatureTypeList().getFeatureType()) {
                profiles.add(new Wfs200TypeProfile(type));
            }
        }
        return profiles;
    }

    @Override
    public void $refresh() {
        InputStream stream = (InputStream)this.client.capabilities().get(InputStream.class);
        try {
            MarshallerPool pool = WFSMarshallerPool.getInstance();
            Unmarshaller unmarshaller = pool.acquireUnmarshaller();
            Object obj = unmarshaller.unmarshal(stream);
            if (obj instanceof JAXBElement) {
                obj = ((JAXBElement)obj).getValue();
                this.capabilities = (WFSCapabilitiesType)obj;
            }
        }
        catch (Exception e) {
            Utils.unchecked("cannot read OGC WFS GetCapabilities document", e);
        }
    }
}

