/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.virtualrepository.Asset;
import org.virtualrepository.AssetType;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;

public class ServiceInspector {
    private final ServiceProxy proxy;

    public ServiceInspector(RepositoryService service) {
        this.proxy = service.proxy();
    }

    public List<AssetType> returned(AssetType ... types) {
        Utils.notNull("asset types", (Object)types);
        HashSet<AssetType> supported = new HashSet<AssetType>();
        for (AssetType type : types) {
            if (this.importersFor(type).isEmpty()) continue;
            supported.add(type);
        }
        return new ArrayList<AssetType>(supported);
    }

    public List<AssetType> taken(AssetType ... types) {
        Utils.notNull("asset types", (Object)types);
        HashSet<AssetType> supported = new HashSet<AssetType>();
        for (AssetType type : types) {
            if (this.publishersFor(type).isEmpty()) continue;
            supported.add(type);
        }
        return new ArrayList<AssetType>(supported);
    }

    public <A, T extends Asset> Importer<T, A> importerFor(AssetType type, Class<? extends A> api) {
        Utils.notNull("asset type", (Object)type);
        for (Importer<?, ?> reader : this.importersFor(type)) {
            if (!api.isAssignableFrom(reader.api())) continue;
            Importer<?, ?> typed = reader;
            return typed;
        }
        throw new IllegalStateException("no importer available for type " + type + " with API " + api);
    }

    public Set<? extends Importer<?, ?>> importersFor(AssetType type) {
        Utils.notNull(type);
        HashSet importers = new HashSet();
        for (Importer<?, ?> importer : this.proxy.importers()) {
            if (!importer.type().equals(type)) continue;
            importers.add(importer);
        }
        return importers;
    }

    public Set<? extends Publisher<?, ?>> publishersFor(AssetType type) {
        Utils.notNull(type);
        HashSet publishers = new HashSet();
        for (Publisher<?, ?> publisher : this.proxy.publishers()) {
            if (!publisher.type().equals(type)) continue;
            publishers.add(publisher);
        }
        return publishers;
    }

    public <A, T extends Asset> Publisher<T, A> publisherFor(AssetType type, Class<? extends A> api) {
        Utils.notNull("asset type", (Object)type);
        Utils.notNull(api);
        for (Publisher<?, ?> writer : this.publishersFor(type)) {
            if (!writer.api().isAssignableFrom(api)) continue;
            Publisher<?, ?> typed = writer;
            return typed;
        }
        throw new IllegalStateException("no importer available for type " + type + " with API " + api);
    }

    public boolean returns(AssetType type, Class<?> api) {
        try {
            this.importerFor(type, api);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public boolean takes(AssetType type, Class<?> api) {
        try {
            this.publisherFor(type, api);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

