/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.virtualrepository.csv.CsvAsset;
import org.virtualrepository.spi.Transform;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Table2CsvStream<T extends CsvAsset>
implements Transform<T, Table, InputStream> {
    @Override
    public InputStream apply(CsvAsset asset, Table table) throws Exception {
        StringWriter stream = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)stream, asset.delimiter(), asset.quote());
        ArrayList<String> values = new ArrayList<String>();
        asset.setColumns(table.columns().toArray(new Column[0]));
        for (Row row : table) {
            values.clear();
            for (Column column : table.columns()) {
                values.add(row.get(column));
            }
            writer.writeNext(values.toArray(new String[0]));
        }
        writer.flush();
        writer.close();
        return new ByteArrayInputStream(stream.toString().getBytes(asset.encoding()));
    }

    @Override
    public Class<Table> inputAPI() {
        return Table.class;
    }

    @Override
    public Class<InputStream> outputAPI() {
        return InputStream.class;
    }
}

