/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.sdmx;

import java.net.URI;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.impl.AbstractAsset;
import org.virtualrepository.impl.Type;
import org.virtualrepository.sdmx.SdmxGenericType;

public abstract class SdmxAsset
extends AbstractAsset {
    public static final Type<SdmxAsset> type = new SdmxGenericType();
    private String version;
    private String remoteId;
    private String agency;
    private URI uri;
    private String status;

    protected <T extends SdmxAsset> SdmxAsset(Type<T> type, String urn, String id, String version, String name, Property ... properties) {
        super(type, urn, name, properties);
        Utils.notNull("identifier", id);
        this.remoteId = id;
        Utils.notNull("version", id);
        this.version = version;
    }

    protected <T extends SdmxAsset> SdmxAsset(Type<T> type, String name, RepositoryService service, Property ... properties) {
        super(type, name, service, properties);
    }

    public String agency() {
        return this.agency;
    }

    public void setAgency(String agency) {
        Utils.notNull("agency", agency);
        this.agency = agency;
    }

    public URI uri() {
        return this.uri;
    }

    public void setURI(URI uri) {
        Utils.notNull("uri", uri);
        this.uri = uri;
    }

    public String version() {
        return this.version;
    }

    public String remoteId() {
        return this.remoteId;
    }

    public String status() {
        return this.status;
    }

    public void setStatus(String status) {
        Utils.notNull("status", status);
        this.status = status;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [agency()=" + this.agency() + ", uri()=" + this.uri() + ", version()=" + this.version() + ", remoteId()=" + this.remoteId() + ", status()=" + this.status() + ", id()=" + this.id() + ", type()=" + this.type() + ", service()=" + this.service() + ", name()=" + this.name() + ", properties()=" + this.properties() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.agency == null ? 0 : this.agency.hashCode());
        result = 31 * result + (this.remoteId == null ? 0 : this.remoteId.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdmxAsset other = (SdmxAsset)obj;
        if (this.agency == null ? other.agency != null : !this.agency.equals(other.agency)) {
            return false;
        }
        if (this.remoteId == null ? other.remoteId != null : !this.remoteId.equals(other.remoteId)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

