/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtualrepository.csv.CsvAsset;
import org.virtualrepository.impl.PropertyHolder;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.DefaultTable;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class CsvTable
extends PropertyHolder
implements Table {
    private static final Logger log = LoggerFactory.getLogger(CsvTable.class);
    private final Table inner;
    private final CsvAsset asset;
    private final CSVReader reader;
    List<Column> columns = new ArrayList<Column>();

    public CsvTable(CsvAsset asset, InputStream stream) {
        this.asset = asset;
        this.reader = this.validateAssetAndBuildReader(asset, stream);
        RowIterator iterator = new RowIterator();
        this.columns = asset.columns();
        this.inner = new DefaultTable(asset.columns(), iterator);
    }

    private CSVReader validateAssetAndBuildReader(CsvAsset asset, InputStream stream) {
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(stream, asset.encoding()), asset.delimiter(), asset.quote());
        ArrayList<Column> columns = new ArrayList<Column>();
        int i = 1;
        if (asset.hasHeader()) {
            try {
                for (String name : reader.readNext()) {
                    if (name == null || name.isEmpty()) {
                        name = this.nameFor(i);
                    }
                    columns.add(new Column(name));
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid CSV asset " + asset.id() + ": cannot read stream", e);
            }
        }
        if (!columns.isEmpty()) {
            this.updateColumns(columns);
        }
        return reader;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.inner.iterator();
    }

    private void updateColumns(List<Column> newColumns) {
        this.columns = newColumns;
        this.asset.setColumns(newColumns.toArray(new Column[0]));
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    private String nameFor(int i) {
        return "column-" + i;
    }

    public String toString() {
        int maxLen = 100;
        return "Table [columns=" + (this.columns != null ? this.columns.subList(0, Math.min(this.columns.size(), 100)) : null) + ", properties=" + this.inner.properties() + "]";
    }

    class RowIterator
    implements Iterator<Row> {
        private final Map<QName, String> data = new HashMap<QName, String>();
        private String[] row;
        private Throwable error;
        private int count;

        RowIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.row != null) {
                return true;
            }
            if (CsvTable.this.asset.rows() <= (long)this.count) {
                this.close();
                return false;
            }
            try {
                this.row = CsvTable.this.reader.readNext();
                ++this.count;
            }
            catch (IOException e) {
                this.error = e;
            }
            return this.row != null;
        }

        @Override
        public Row next() {
            try {
                this.checkRow();
            }
            catch (RuntimeException e) {
                this.close();
            }
            Row result = this.buildRow();
            this.row = null;
            return result;
        }

        private void synthesiseColumns(String[] row) {
            if (row.length > CsvTable.this.columns.size()) {
                ArrayList<Column> newcolumns = new ArrayList<Column>();
                for (int i = 0; i < row.length; ++i) {
                    if (i + 1 <= CsvTable.this.columns.size()) {
                        newcolumns.add(CsvTable.this.columns.get(i));
                        continue;
                    }
                    newcolumns.add(new Column(CsvTable.this.nameFor(i + 1)));
                }
                CsvTable.this.updateColumns(newcolumns);
            }
        }

        private void checkRow() {
            if (this.error != null) {
                throw new RuntimeException(this.error);
            }
            if (this.row == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
        }

        private Row buildRow() {
            this.data.clear();
            this.synthesiseColumns(this.row);
            for (int i = 0; i < this.row.length; ++i) {
                this.data.put(CsvTable.this.columns.get(i).name(), this.row[i]);
            }
            return new Row(this.data);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void close() {
            try {
                CsvTable.this.reader.close();
            }
            catch (Exception e) {
                log.warn("could not close CSV stream", (Throwable)e);
            }
        }
    }
}

