/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.csv;

import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.csv.CsvAsset;
import org.virtualrepository.csv.CsvCodelistType;
import org.virtualrepository.impl.Type;

public final class CsvCodelist
extends CsvAsset {
    private int codeColumn;
    public static final Type<CsvCodelist> type = new CsvCodelistType();

    public CsvCodelist(String id, String name, int codeColumnIndex, Property ... properties) {
        super(type, id, name, properties);
        this.setCodeColumn(codeColumnIndex);
    }

    public <T extends CsvAsset> CsvCodelist(String name, int codeColumnIndex, RepositoryService service, Property ... properties) {
        super(type, name, service, properties);
        this.setCodeColumn(codeColumnIndex);
    }

    public <T extends CsvAsset> CsvCodelist(String id, String name, int codeColumnIndex, RepositoryService service, Property ... properties) {
        super(type, id, name, service, properties);
        this.setCodeColumn(codeColumnIndex);
    }

    public int codeColumn() {
        return this.codeColumn;
    }

    protected void setCodeColumn(int codeColumnIndex) {
        Utils.notNull("code column index", codeColumnIndex);
        this.codeColumn = codeColumnIndex;
    }

    @Override
    public String toString() {
        int maxLen = 100;
        return "CsvCodelist [codeColumn=" + this.codeColumn + ", delimiter()=" + this.delimiter() + ", quote()=" + this.quote() + ", hasHeader()=" + this.hasHeader() + ", encoding()=" + this.encoding() + ", columns()=" + (this.columns() != null ? this.columns().subList(0, Math.min(this.columns().size(), 100)) : null) + ", rows()=" + this.rows() + ", id()=" + this.id() + ", type()=" + this.type() + ", service()=" + this.service() + ", name()=" + this.name() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.codeColumn;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsvCodelist other = (CsvCodelist)obj;
        return this.codeColumn == other.codeColumn;
    }
}

