/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.spi;

import org.virtualrepository.Asset;
import org.virtualrepository.Utils;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Transform;

public class ImportAdapter<T extends Asset, A1, A2>
implements Importer<T, A2> {
    private final Importer<T, A1> importer;
    private final Transform<T, A1, A2> transform;

    public static <T extends Asset, A1, A2> Importer<T, A2> adapt(Importer<T, A1> importer, Transform<T, A1, A2> transform) {
        Utils.notNull("importer", importer);
        Utils.notNull("transform", transform);
        return new ImportAdapter<T, A1, A2>(importer, transform);
    }

    private ImportAdapter(Importer<T, A1> importer, Transform<T, A1, A2> transform) {
        this.importer = importer;
        this.transform = transform;
    }

    @Override
    public Type<? extends T> type() {
        return this.importer.type();
    }

    @Override
    public Class<A2> api() {
        return this.transform.outputAPI();
    }

    @Override
    public A2 retrieve(T asset) throws Exception {
        return this.transform.apply(asset, this.importer.retrieve(asset));
    }
}

