/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sdmxregistry;

import java.util.ArrayList;
import java.util.List;
import org.virtual.sdmxregistry.ClientFactory;
import org.virtual.sdmxregistry.Registry;
import org.virtual.sdmxregistry.RegistryBrowser;
import org.virtual.sdmxregistry.RegistryImporter;
import org.virtual.sdmxregistry.RegistryPublisher;
import org.virtual.sdmxregistry.csv.CsvRegistryImporter;
import org.virtualrepository.Utils;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;

public abstract class RegistryProxy<T extends Registry>
implements ServiceProxy {
    private final T registry;
    private final RegistryBrowser browser;
    private final List<Importer<?, ?>> importers = new ArrayList();
    private final List<Publisher<?, ?>> publishers = new ArrayList();

    public RegistryProxy(T registry) {
        Utils.notNull((String)"registry proxy", registry);
        this.registry = registry;
        ClientFactory factory = this.factory();
        this.browser = new RegistryBrowser(factory);
        RegistryImporter importer = new RegistryImporter(factory);
        this.importers.add(importer);
        this.importers.add(new CsvRegistryImporter(importer));
        if (!registry.isReadonly()) {
            this.publishers.add(new RegistryPublisher(factory));
        }
    }

    protected T registry() {
        return this.registry;
    }

    public Browser browser() {
        return this.browser;
    }

    public List<Importer<?, ?>> importers() {
        return this.importers;
    }

    public List<Publisher<?, ?>> publishers() {
        return this.publishers;
    }

    public String toString() {
        return this.registry.toString();
    }

    public abstract ClientFactory factory();
}

