/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.virtual.sr.RepositoryConfiguration;
import org.virtual.sr.utils.Constants;
import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.MutableAsset;

public class RepositoryBrowser
implements Browser {
    private final RepositoryConfiguration configuration;

    public RepositoryBrowser(RepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public Iterable<? extends MutableAsset> discover(Collection<? extends AssetType> types) throws Exception {
        if (types.contains(SdmxCodelist.type)) {
            return this.discoverSdmxCodelists();
        }
        if (types.contains(CsvCodelist.type)) {
            return this.discoverCsvCodelists();
        }
        throw new IllegalArgumentException("unsupported types " + types);
    }

    public Collection<SdmxCodelist> discoverSdmxCodelists() throws Exception {
        ArrayList<SdmxCodelist> assets = new ArrayList<SdmxCodelist>();
        String endpoint = this.configuration.public_endpoint_query().toString();
        Query q = QueryFactory.create((String)this.configuration.query_all_sdmx_codelist());
        ResultSet codelists = QueryExecutionFactory.sparqlService((String)endpoint, (Query)q).execSelect();
        System.out.println("");
        while (codelists.hasNext()) {
            QuerySolution next = codelists.next();
            String gUri = next.getResource("?g").getURI();
            String name = next.getResource("?g").getLocalName();
            String version = "sr_1.0";
            String creator = "claudio.baldassarre";
            SdmxCodelist asset = new SdmxCodelist(gUri, gUri, version, name);
            asset.properties().add(new Property[]{Constants.ownerProperty(creator)});
            assets.add(asset);
        }
        return assets;
    }

    public Collection<SdmxCodelist> discoverCsvCodelists() throws Exception {
        return Collections.emptyList();
    }
}

