/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.virtual.sr.RdfImporter;
import org.virtual.sr.RepositoryBrowser;
import org.virtual.sr.RepositoryConfiguration;
import org.virtual.sr.RepositoryPublisher;
import org.virtual.sr.transforms.Asset2Rdf;
import org.virtual.sr.transforms.Comet2Xml;
import org.virtual.sr.transforms.Csv2Xml;
import org.virtual.sr.transforms.GeoFeatureStream2Xml;
import org.virtual.sr.transforms.Sdmx2Table;
import org.virtual.sr.transforms.Sdmx2Xml;
import org.virtual.sr.transforms.XmlTransform;
import org.virtual.sr.transforms.codelist.Rdf2SdmxCodelist;
import org.virtualrepository.Asset;
import org.virtualrepository.comet.CometAsset;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.impl.Type;
import org.virtualrepository.ows.WfsFeatureType;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.ImportAdapter;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Lifecycle;
import org.virtualrepository.spi.PublishAdapter;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;
import org.virtualrepository.spi.Transform;

public class RepositoryProxy
implements ServiceProxy,
Lifecycle {
    private static final String CONFIGURATION_FILE = "sr.properties";
    private RepositoryBrowser browser;
    private final List<Publisher<?, ?>> publishers = new ArrayList();
    private final List<Importer<?, ?>> importers = new ArrayList();

    public void init() throws Exception {
        Properties properties = new Properties();
        try {
            properties.load(RepositoryProxy.class.getClassLoader().getResourceAsStream(CONFIGURATION_FILE));
        }
        catch (Exception e) {
            throw new IllegalStateException("missing configuration: configuration file sr.properties not on classpath");
        }
        RepositoryConfiguration configuration = null;
        try {
            configuration = new RepositoryConfiguration(properties);
        }
        catch (Exception e) {
            throw new IllegalStateException("invalid configuration (see cause) ", e);
        }
        this.browser = new RepositoryBrowser(configuration);
        this.publishers.add(this.publisherFor(SdmxCodelist.type, new Sdmx2Xml(), configuration));
        this.publishers.add(this.publisherFor(CometAsset.type, new Comet2Xml(), configuration));
        this.publishers.add(this.publisherFor(CsvCodelist.type, new Csv2Xml(), configuration));
        this.publishers.add(this.publisherFor(WfsFeatureType.type, new GeoFeatureStream2Xml(), configuration));
        RdfImporter rdfCodelistImporter = new RdfImporter(SdmxCodelist.type, configuration);
        Importer sdmxCodelistImporter = ImportAdapter.adapt(rdfCodelistImporter, (Transform)new Rdf2SdmxCodelist());
        this.importers.add(sdmxCodelistImporter);
        Importer tableCodelistImporter = ImportAdapter.adapt((Importer)sdmxCodelistImporter, (Transform)new Sdmx2Table());
        this.importers.add(tableCodelistImporter);
    }

    public Browser browser() {
        return this.browser;
    }

    public List<? extends Importer<?, ?>> importers() {
        return this.importers;
    }

    public List<? extends Publisher<?, ?>> publishers() {
        return this.publishers;
    }

    private <A extends Asset, API> Publisher<A, API> publisherFor(Type<A> type, XmlTransform<API> transform, RepositoryConfiguration configuration) {
        RepositoryPublisher<A> p = new RepositoryPublisher<A>(type, configuration);
        return PublishAdapter.adapt(p, new Asset2Rdf(transform));
    }
}

